/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.workflow;

import com.mathworks.installservicehandler.InstallServiceHandlerUtilities;
import com.mathworks.installservicehandler.exception.InstallServiceHandlerInternalException;
import com.mathworks.installservicehandler.workflow.AbstractInstallerWorkflow;
import com.mathworks.installservicehandler.workflow.JsonProvidedWorkflow;
import com.mathworks.installservicehandler.workflow.StateImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class JsonProvidedWorkflowImpl
extends AbstractInstallerWorkflow
implements JsonProvidedWorkflow {
    @Override
    public void initializeWorkflow() throws InstallServiceHandlerInternalException {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.provideJsonFile());
            String jsonData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Map returnedMap = InstallServiceHandlerUtilities.convertJsonToPojo(jsonData, Map.class);
            int sizeOfMap = returnedMap.keySet().size();
            int count = 0;
            for (String key : returnedMap.keySet()) {
                this.stateMap.put(key, new StateImpl((String)returnedMap.get(key)));
                if (count < sizeOfMap - 1) {
                    this.stateMap.put(key, new StateImpl((String)returnedMap.get(key)));
                } else {
                    this.stateMap.put(key, new StateImpl((String)returnedMap.get(key), true));
                }
                ++count;
            }
        }
        catch (IOException e) {
            throw new InstallServiceHandlerInternalException(e);
        }
    }
}

