/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.workflow;

import com.mathworks.installservicehandler.context.AbstractWorkflowContextImpl;
import com.mathworks.installservicehandler.workflow.State;
import com.mathworks.installservicehandler.workflow.StateTransitionHandler;
import com.mathworks.installservicehandler.workflow.Workflow;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

abstract class AbstractInstallerWorkflow
implements Workflow {
    protected Map<String, State> stateMap = new TreeMap<String, State>();
    protected Map<String, StateTransitionHandler> stateTransitionHandlerMap = new HashMap<String, StateTransitionHandler>();
    private final StateTransitionHandler NEVER_SKIP_HANDLER = new StateTransitionHandler(){

        @Override
        public void setShouldSkip(State currentState, AbstractWorkflowContextImpl context) {
            currentState.setShouldSkip(false);
        }
    };

    AbstractInstallerWorkflow() {
        this.initializeWorkflow();
        this.populateDefaultStateTansitionMap();
    }

    @Override
    public State getNextState(String currentValue, AbstractWorkflowContextImpl workflowContext) {
        State nextState = this.stateMap.get(currentValue);
        this.setStateTransition(nextState, workflowContext);
        return nextState;
    }

    @Override
    public abstract void initializeWorkflow();

    private void populateDefaultStateTansitionMap() {
        for (String key : this.stateMap.keySet()) {
            this.stateTransitionHandlerMap.put(key, this.NEVER_SKIP_HANDLER);
        }
    }

    private void setStateTransition(State currentState, AbstractWorkflowContextImpl workflowContext) {
        StateTransitionHandler handler = this.stateTransitionHandlerMap.get(currentState.getValue());
        if (handler != null) {
            handler.setShouldSkip(currentState, workflowContext);
        }
    }
}

