/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.resources;

import com.mathworks.installservicehandler.resources.ResourceKey;
import com.mathworks.installservicehandler.resources.ResourceRetriever;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ResourceLocale;
import com.mathworks.instutil.ResourceLocaleFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceRetrieverImpl<R extends ResourceKey>
implements ResourceRetriever<R> {
    private final Collection<ResourceBundle> bundles = new ArrayList<ResourceBundle>();

    public ResourceRetrieverImpl(String defaultBaseName, String ... additionalBaseNames) {
        PlatformImpl platform = new PlatformImpl();
        ResourceLocale resLocale = ResourceLocaleFactory.createResourceLocale((Platform)platform);
        for (String baseName : additionalBaseNames) {
            this.bundles.add(resLocale.getBundle(baseName));
            try {
                this.bundles.add(resLocale.getBundle(ResourceRetrieverImpl.getUntranslatedBundleName(baseName)));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this.bundles.add(resLocale.getBundle(ResourceRetrieverImpl.getGeneratedPropertiesFile(baseName)));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.bundles.add(resLocale.getBundle(defaultBaseName));
        this.bundles.add(resLocale.getBundle(ResourceRetrieverImpl.getUntranslatedBundleName(defaultBaseName)));
    }

    private static String getGeneratedPropertiesFile(String baseName) {
        return baseName.concat("_generated_props");
    }

    private static String getUntranslatedBundleName(String baseName) {
        return baseName.concat("_notranslation");
    }

    @Override
    public String getResource(R key, Object ... arguments) {
        return this.getResource(key.getKey(), arguments);
    }

    @Override
    public String getResource(String resourceKey, Object ... arguments) {
        for (ResourceBundle bundle : this.bundles) {
            try {
                String value = bundle.getString(resourceKey);
                return MessageFormat.format(value, arguments);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return "";
    }
}

