/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.monitor;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.install_task.TaskStatusObserver;
import com.mathworks.installservicehandler.monitor.LongRunningProcessMonitorStatusObserver;
import com.mathworks.installservicehandler.monitor.StatusType;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class LongRunningProcessMonitor<T extends BackgroundTask & InstallFlowControlHandler>
implements Subscriber {
    private static final Map<String, LongRunningProcessMonitor> monitors = new HashMap<String, LongRunningProcessMonitor>();
    private String id;
    private T backgroundTask;
    private String messageChannel;
    private final boolean messageServiceAvailable;
    private final Collection<LongRunningProcessMonitorStatusObserver> observers = new ArrayList<LongRunningProcessMonitorStatusObserver>();

    private static void addProcessMonitor(LongRunningProcessMonitor monitor) {
        monitors.put(monitor.getId(), monitor);
    }

    public static LongRunningProcessMonitor getProcessMonitor(String id) {
        return monitors.get(id);
    }

    public static <T extends BackgroundTask & InstallFlowControlHandler> LongRunningProcessMonitor createLongRunningProcessMonitor(String id, T task) {
        return new LongRunningProcessMonitor<T>(id, task);
    }

    private boolean checkMessageServiceAvailability() {
        boolean isAvailable = true;
        try {
            MessageServiceFactory.getMessageService();
        }
        catch (Exception noMessageServiceImpl) {
            isAvailable = false;
        }
        return isAvailable;
    }

    private LongRunningProcessMonitor(String id, T task) {
        this.id = id;
        this.messageServiceAvailable = this.checkMessageServiceAvailability();
        this.buildMessageChannel();
        this.register(task);
        LongRunningProcessMonitor.addProcessMonitor(this);
    }

    public String getId() {
        return this.id;
    }

    public String getMessageChannel() {
        return this.messageChannel;
    }

    private void buildMessageChannel() {
        this.messageChannel = '/' + this.getClass().getSimpleName() + '/' + this.getId();
        if (this.messageServiceAvailable) {
            MessageServiceFactory.getMessageService().subscribe(this.messageChannel, (Subscriber)this);
        }
    }

    private void register(T task) {
        this.backgroundTask = task;
        StatusMonitor statusMonitor = new StatusMonitor();
        task.addStatusObserver((TaskStatusObserver)statusMonitor);
    }

    public void cancelTask() {
        this.backgroundTask.cancel();
        if (this.messageServiceAvailable) {
            MessageServiceFactory.getMessageService().unsubscribe(this.messageChannel, (Subscriber)this);
        }
        this.notifyObservers(StatusType.CANCEL, "User_Cancelled");
    }

    public void handle(Message message) {
        Object messageData = message.getData();
        Map params = (Map)messageData;
        StatusType statusType = StatusType.valueOf(((String)params.get("statusType")).toUpperCase());
        if (statusType.equals((Object)StatusType.CANCEL)) {
            this.cancelTask();
        }
    }

    public void attach(LongRunningProcessMonitorStatusObserver observer) {
        this.observers.add(observer);
    }

    public void detach(LongRunningProcessMonitorStatusObserver observer) {
        this.observers.remove(observer);
    }

    private Collection<LongRunningProcessMonitorStatusObserver> getObservers() {
        return this.observers;
    }

    private void notifyObservers(StatusType type, String value) {
        for (LongRunningProcessMonitorStatusObserver observer : this.getObservers()) {
            observer.update(type, value);
        }
        if (this.messageServiceAvailable) {
            StringBuilder jsonObject = new StringBuilder();
            jsonObject.append("{\"statusType\":\"").append(type.name()).append("\",\"statusValue\":\"").append(value).append("\"}");
            MessageServiceFactory.getMessageService().publish(this.getMessageChannel(), (Object)jsonObject.toString());
        }
    }

    private class StatusMonitor
    implements TaskStatusObserver {
        public void updateOverallStatus(String value) {
            LongRunningProcessMonitor.this.notifyObservers(StatusType.OVERALL, value);
        }

        public void updateCurrentStatus(String value) {
            LongRunningProcessMonitor.this.notifyObservers(StatusType.CURRENT, value);
        }

        public void updateStatusDetails(String value) {
            LongRunningProcessMonitor.this.notifyObservers(StatusType.DETAILS, value);
        }

        public void updatePercentComplete(int value) {
            LongRunningProcessMonitor.this.notifyObservers(StatusType.PERCENTAGE, String.valueOf(value));
        }
    }
}

