/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.context;

import com.google.inject.Module;
import com.mathworks.installservicehandler.context.ServiceContext;
import com.mathworks.installservicehandler.context.ServiceContextSessionIdGenerator;
import com.mathworks.installservicehandler.exception.InstallServiceHandlerInternalException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ServiceContextManager {
    private static final Map<String, ServiceContext> contextMap = new HashMap<String, ServiceContext>();

    private ServiceContextManager() {
    }

    public static <C extends ServiceContext> String register(Class<C> contextClass, Module ... modules) {
        String sessionId = ServiceContextSessionIdGenerator.generateId();
        try {
            if (modules.length > 0) {
                contextMap.put(sessionId, (ServiceContext)contextClass.getConstructor(Module[].class).newInstance(new Object[]{modules}));
            } else {
                contextMap.put(sessionId, (ServiceContext)contextClass.newInstance());
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InstallServiceHandlerInternalException(e);
        }
        return sessionId;
    }

    public static ServiceContext getContext(String sessionId) {
        return contextMap.get(sessionId);
    }

    public static void removeContext(String sessionId) {
        contextMap.remove(sessionId);
    }
}

