/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.context;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.installservicehandler.AllowsModuleOverride;
import com.mathworks.installservicehandler.InstallServiceHandlerUtilities;
import com.mathworks.installservicehandler.context.AbstractInjectableContextImpl;
import com.mathworks.installservicehandler.context.ServiceContextManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ModuleOverrider
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String jsonData = (String)methodInvocation.getArguments()[0];
        Method invokedMethod = methodInvocation.getMethod();
        Method nonInjectedMethod = invokedMethod.getDeclaringClass().getMethod(invokedMethod.getName(), String.class);
        AllowsModuleOverride annotation = nonInjectedMethod.getAnnotation(AllowsModuleOverride.class);
        Class<?> moduleProvider = Class.forName(annotation.moduleProvider());
        String sessionid = InstallServiceHandlerUtilities.extractSessionIdFromJson(jsonData);
        AbstractInjectableContextImpl context = (AbstractInjectableContextImpl)ServiceContextManager.getContext(sessionid);
        Injector originalInjector = context.getInjector(new Module[0]);
        context.setInjector(null);
        Module modulesForInjector = this.getModulesForInjector(annotation, moduleProvider, originalInjector);
        context.getInjector(modulesForInjector);
        String result = (String)methodInvocation.proceed();
        if (!annotation.shouldPersist()) {
            context.setInjector(originalInjector);
        }
        return result;
    }

    private Module getModulesForInjector(AllowsModuleOverride annotation, Class<?> moduleProvider, final Injector originalInjector) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Module[] listOfModules = (Module[])moduleProvider.getMethod("getModules", new Class[0]).invoke(null, new Object[0]);
        Module modulesForInjector = Modules.combine((Module[])listOfModules);
        if (annotation.shouldOverlay()) {
            final Collection classesNotToBind = (Collection)moduleProvider.getMethod("classesNotToRebind", new Class[0]).invoke(null, new Object[0]);
            AbstractModule existingBindings = new AbstractModule(){

                protected void configure() {
                    for (Map.Entry entry : originalInjector.getBindings().entrySet()) {
                        try {
                            if (classesNotToBind.contains(((Key)entry.getKey()).getTypeLiteral().getRawType()) || ((Binding)entry.getValue()).getSource().equals("[unknown source]")) continue;
                            this.bind((Key)entry.getKey()).toProvider(((Binding)entry.getValue()).getProvider());
                        }
                        catch (ConfigurationException configurationException) {}
                    }
                }
            };
            modulesForInjector = Modules.override((Module[])new Module[]{existingBindings}).with(new Module[]{modulesForInjector});
        }
        return modulesForInjector;
    }

    private static class DefaultModuleProvider {
        private DefaultModuleProvider() {
        }

        public static Module[] getModules() {
            return new Module[0];
        }
    }
}

