/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler.context;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installservicehandler.context.AbstractServiceContextImpl;
import com.mathworks.installservicehandler.context.InjectableContext;
import com.mathworks.installservicehandler.context.ServiceContextDataKey;
import com.mathworks.instutil.logging.AppLogger;

public abstract class AbstractInjectableContextImpl
extends AbstractServiceContextImpl
implements InjectableContext {
    @Override
    public Injector getInjector(Module ... modules) {
        Injector injector = (Injector)this.getCachedValue(ServiceContextDataKey.DEPENDENCY_INJECTOR);
        if (injector == null) {
            injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])this.getDefaultModules()).with(modules)});
            this.setInjector(injector);
        } else if (modules != null && modules.length > 0) {
            injector = injector.createChildInjector(modules);
            this.setInjector(injector);
        }
        return injector;
    }

    protected Injector setInjector(Injector injector) {
        return (Injector)this.setCachedValue(ServiceContextDataKey.DEPENDENCY_INJECTOR, injector);
    }

    @Override
    public <T> T getInstanceFor(Class<T> classToGet) {
        return (T)this.getInjector(new Module[0]).getInstance(classToGet);
    }

    protected abstract Module[] getDefaultModules();

    public AppLogger getAppLogger() {
        return this.getInstanceFor(AppLogger.class);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return (ExceptionHandler)this.getInjector(new Module[0]).getInstance(ExceptionHandler.class);
    }
}

