/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler;

import com.mathworks.cosg.CosgMessageHandler;
import com.mathworks.cosg.CosgRegistryFactory;
import com.mathworks.cosg.CosgResponseWrapper;
import com.mathworks.installservicehandler.InstallService;
import com.mathworks.installservicehandler.InstallServiceHandlerFactory;
import com.mathworks.installservicehandler.JsonPassThroughResponseWrapper;
import com.mathworks.installservicehandler.exception.InstallServiceBadConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonPassThroughServiceHandler
implements CosgMessageHandler<String, String> {
    private static final Map<String, List<String>> HANDLER_MAPPING = new HashMap<String, List<String>>();

    static <T extends InstallService> void register(Class<T> theClass, String ... serviceMethods) {
        String fullName = theClass.getName();
        String simpleName = theClass.getSimpleName();
        List<Object> services = HANDLER_MAPPING.containsKey(fullName) ? HANDLER_MAPPING.get(fullName) : new ArrayList();
        for (String service : serviceMethods) {
            services.add(simpleName + "." + service);
        }
        HANDLER_MAPPING.put(fullName, services);
    }

    static void init() throws InstallServiceBadConfigurationException {
        JsonPassThroughServiceHandler instance = new JsonPassThroughServiceHandler();
        for (Map.Entry<String, List<String>> entry : HANDLER_MAPPING.entrySet()) {
            InstallServiceHandlerFactory.register(entry.getKey());
            for (String serviceMethod : entry.getValue()) {
                CosgRegistryFactory.getRegistry().registerMessageHandler(serviceMethod, (CosgMessageHandler)instance);
            }
        }
    }

    public CosgResponseWrapper<String> handle(String requestType, String requestData) {
        return new JsonPassThroughResponseWrapper(requestType, requestData);
    }
}

