/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler;

import com.mathworks.cosg.CosgResponseWrapper;
import com.mathworks.installservicehandler.InstallService;
import com.mathworks.installservicehandler.InstallServiceHandlerFactory;
import com.mathworks.installservicehandler.exception.InstallServiceExecutionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JsonPassThroughResponseWrapper
implements CosgResponseWrapper<String> {
    private String data;
    private String type;

    JsonPassThroughResponseWrapper(String requestType, String requestData) {
        this.type = requestType;
        this.data = requestData;
    }

    public String getData() throws InstallServiceExecutionException {
        try {
            String[] parts = this.type.split("\\.");
            Class<? extends InstallService> serviceClass = InstallServiceHandlerFactory.getServiceClass(parts[0]);
            Method method = serviceClass.getMethod(parts[1], String.class);
            return (String)method.invoke(InstallServiceHandlerFactory.createServiceInstance(parts[0]), this.data);
        }
        catch (InvocationTargetException ite) {
            throw new InstallServiceExecutionException(this.type, ite.getCause());
        }
        catch (Exception e) {
            throw new InstallServiceExecutionException(this.type, e);
        }
    }

    public String getType() {
        return this.type + "Response";
    }
}

