/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installservicehandler;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.util.Modules;
import com.mathworks.installservicehandler.InstallService;
import com.mathworks.installservicehandler.JsonPassThroughServiceHandler;
import com.mathworks.installservicehandler.exception.InstallServiceBadConfigurationException;
import com.mathworks.installservicehandler.exception.InstallServiceHandlerInternalException;
import com.mathworks.installservicehandler.exception.InstallServiceNotRegisteredException;
import com.mathworks.installservicehandler.xml.ServiceConfigType;
import com.mathworks.installservicehandler.xml.ServiceContainerType;
import com.mathworks.installservicehandler.xml.ServiceType;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.xml.sax.SAXException;

public class InstallServiceHandlerFactory {
    public static final String SCHEMA_DEF_FILE = "config/installserviceschema.xsd";
    private static final Map<String, Class<? extends InstallService>> serviceMap = new HashMap<String, Class<? extends InstallService>>();
    private static final Map<Class, MethodInterceptor> interceptors = new HashMap<Class, MethodInterceptor>();
    private static Module interceptorModule = Modules.EMPTY_MODULE;

    private InstallServiceHandlerFactory() {
    }

    public static <T extends Annotation> void unregisterInterceptor(Class<T> annotationType) {
        interceptors.remove(annotationType);
        InstallServiceHandlerFactory.rebuildInterceptorModule();
    }

    public static <T extends Annotation> void registerInterceptor(Class<T> annotationType, MethodInterceptor interceptor) {
        interceptors.put(annotationType, interceptor);
        InstallServiceHandlerFactory.rebuildInterceptorModule();
    }

    private static void rebuildInterceptorModule() {
        interceptorModule = new AbstractModule(){

            protected void configure() {
                for (Map.Entry entry : interceptors.entrySet()) {
                    this.bindInterceptor(Matchers.any(), Matchers.annotatedWith((Class)((Class)entry.getKey())), new MethodInterceptor[]{(MethodInterceptor)entry.getValue()});
                }
            }
        };
    }

    public static void init(URL ... urls) throws InstallServiceBadConfigurationException {
        for (URL configFile : urls) {
            ServiceConfigType serviceConfig = InstallServiceHandlerFactory.unmarshallConfigData(configFile);
            InstallServiceHandlerFactory.processServiceConfig(serviceConfig);
        }
        JsonPassThroughServiceHandler.init();
    }

    public static void init(String ... configFiles) throws InstallServiceBadConfigurationException {
        ArrayList<URL> urls = new ArrayList<URL>(configFiles.length);
        for (String configFile : configFiles) {
            try {
                String absolutePath = new File(configFile).getAbsolutePath();
                urls.add(new URI("file", absolutePath, "").toURL());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new InstallServiceBadConfigurationException("The following location could not be read: " + configFile, e);
            }
        }
        InstallServiceHandlerFactory.init(urls.toArray(new URL[urls.size()]));
    }

    static void register(String className) throws InstallServiceBadConfigurationException {
        try {
            Class<InstallService> classToReg = Class.forName(className).asSubclass(InstallService.class);
            serviceMap.put(classToReg.getSimpleName(), classToReg);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstallServiceBadConfigurationException("Invalid service class: " + className, cnfe);
        }
    }

    static <T extends InstallService> T createServiceInstance(final String id) throws InstantiationException {
        if (!serviceMap.containsKey(id)) {
            throw new InstallServiceNotRegisteredException(id);
        }
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(InstallService.class).to((Class)serviceMap.get(id));
                }
            }}).with(new Module[]{interceptorModule})});
            return (T)((InstallService)injector.getInstance(InstallService.class));
        }
        catch (CreationException ce) {
            throw new InstantiationException(ce.getMessage());
        }
    }

    static Class<? extends InstallService> getServiceClass(String id) {
        return serviceMap.get(id);
    }

    private static void processServiceConfig(ServiceConfigType serviceConfig) throws InstallServiceBadConfigurationException {
        for (ServiceContainerType container : serviceConfig.getServiceContainer()) {
            try {
                Class<?> containerClass = Class.forName(container.getPackage() + "." + container.getClassName());
                for (ServiceType service : container.getService()) {
                    try {
                        Class.forName(service.getHandler()).getDeclaredMethod("register", Class.class, String[].class).invoke(null, containerClass, new String[]{service.getMethodName()});
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new InstallServiceBadConfigurationException("Invalid handler: " + service.getHandler(), cnfe);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                throw new InstallServiceHandlerInternalException(ignored);
            }
            catch (ClassNotFoundException cnfe) {
                throw new InstallServiceBadConfigurationException("Invalid service container: " + container.getPackage() + "." + container.getClassName(), cnfe);
            }
        }
    }

    private static ServiceConfigType unmarshallConfigData(URL config) throws InstallServiceBadConfigurationException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"com.mathworks.installservicehandler.xml", (ClassLoader)InstallServiceHandlerFactory.class.getClassLoader());
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(InstallServiceHandlerFactory.class.getClassLoader().getResource(SCHEMA_DEF_FILE));
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            return (ServiceConfigType)((JAXBElement)unmarshaller.unmarshal(config)).getValue();
        }
        catch (JAXBException | SAXException ex) {
            throw new InstallServiceBadConfigurationException("There was a problem parsing the configuration file: " + config, (Exception)ex);
        }
    }
}

