/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.mathworks.install_core_common.webservices.PropertyKey;
import com.mathworks.install_core_common.webservices.SourcePathProvider;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.Platform;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.AuthenticationWSClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.webproxy.ProxyAuthenticator;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import java.util.Properties;
import org.apache.axis2.AxisFault;

public final class WebServicesModule
extends AbstractModule {
    protected void configure() {
        this.bind(ProxyAuthenticator.class).toInstance((Object)WebproxyFactory.createProxyAuthenticator());
        this.bind(DWSRestClientProxy.class).toInstance((Object)new DWSRestClientProxy());
        this.bind(AuthenticationWSClientProxy.class).toInstance((Object)new AuthenticationWSClientProxy());
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.axis2.transport.http", "off");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "off");
    }

    @Provides
    static SourcePathProvider provideSourcePathProvider(final Properties properties) {
        return new SourcePathProvider(){

            @Override
            public String getSourcePath() {
                return properties.getProperty(PropertyKey.ROOTDIR.get());
            }
        };
    }

    @Provides
    static ActivationServiceProxy provideActivationServiceProxy(ProxyConfiguration proxyConfiguration, Properties properties) throws AxisFault {
        return new ActivationServiceProxy(proxyConfiguration, properties);
    }

    @Provides
    @Singleton
    static MWTransportClientProperties provideTCP(Properties properties) {
        MWTransportClientProperties mWTransportClientProperties = MWTransportClientPropertiesFactory.create((String)"http");
        mWTransportClientProperties.setProxyHost(properties.getProperty(PropertyKey.PROXY_HOST.get(), mWTransportClientProperties.getProxyHost()));
        mWTransportClientProperties.setProxyPort(properties.getProperty(PropertyKey.PROXY_PORT.get(), mWTransportClientProperties.getProxyPort()));
        mWTransportClientProperties.setProxyUser(properties.getProperty(PropertyKey.PROXY_USER.get(), mWTransportClientProperties.getProxyUser()));
        mWTransportClientProperties.setProxyPassword(properties.getProperty(PropertyKey.PROXY_PASSWORD.get(), mWTransportClientProperties.getProxyPassword()));
        return mWTransportClientProperties;
    }

    @Provides
    static SystemProxySettings proxySystemProxySettings(Properties properties, SourcePathProvider sourcePathProvider, Platform platform) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        String string2 = string == null ? sourcePathProvider.getSourcePath() : string;
        return WebproxyFactory.createSystemProxySettings((String)platform.getNativeLibraryPath(string2));
    }

    @Provides
    @Singleton
    static ProxyConfiguration provideProxyConfiguration(SystemProxySettings systemProxySettings, Properties properties) {
        WebproxyFactory.setUseSystemProxiesEnabled((boolean)Boolean.parseBoolean(properties.getProperty(PropertyKey.USE_SYSTEM_PROXIES.get(), "true")));
        return WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)systemProxySettings);
    }
}

