/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installservicehandler.CouldThrow;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.dws.client.rest.model.Architectures;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataResponse;
import java.rmi.RemoteException;
import java.util.Locale;

public class GetReleaseDataCallable
extends AbstractWebserviceCallable<ReleaseDataResponse, ReleaseDataResponse> {
    private static final String DOWNLOAD_ONLY_WORKFLOW_TYPE = "downloadOnlyWorkflow";
    private static final String EMPTY_ENTITLEMENT_ID = "";
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String[] selectedArchitectures;
    private final String workFlowType;
    private final DWSRestClientProxy dwsRestClient;
    private final String securityToken;
    private final String entitlementId;
    private final String targetReleaseModel;
    private String releaseString;
    private ReleaseDataResponse releaseDataResponse;
    private final String FIMTAHSEVERITY = "1";

    public GetReleaseDataCallable(String string, String string2, String string3, String string4, String[] stringArray, String string5, DWSRestClientProxy dWSRestClientProxy, ExceptionHandler exceptionHandler) {
        super((WebServiceClientProxy)dWSRestClientProxy, exceptionHandler);
        this.entitlementId = string;
        this.securityToken = string2;
        this.targetReleaseModel = string3;
        this.clientString = string4;
        this.selectedArchitectures = stringArray;
        this.workFlowType = string5;
        this.dwsRestClient = dWSRestClientProxy;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    @CouldThrow
    protected ReleaseDataResponse callService() throws RemoteException {
        ReleaseDataResponse releaseDataResponse = null;
        try {
            Architectures architectures = new Architectures();
            for (String string : this.selectedArchitectures) {
                architectures.getArchitecture().add(string);
            }
            ReleaseDataRequest releaseDataRequest = new ReleaseDataRequest();
            releaseDataRequest.setRelease(this.releaseString);
            releaseDataRequest.setArchitectures(architectures);
            releaseDataRequest.setTargetUpdateRelease(this.targetReleaseModel);
            if (DOWNLOAD_ONLY_WORKFLOW_TYPE.equalsIgnoreCase(this.workFlowType)) {
                releaseDataRequest.setEntitlementId(EMPTY_ENTITLEMENT_ID);
            } else {
                releaseDataRequest.setEntitlementId(this.entitlementId);
            }
            releaseDataResponse = this.dwsRestClient.getReleaseData(Locale.getDefault().toString(), this.clientString, this.securityToken, releaseDataRequest);
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            if ("1".equalsIgnoreCase(mathWorksServiceException.getSeverity())) {
                this.exceptionHandler.handleException((Throwable)mathWorksServiceException, InstallCoreCommonResourceKeys.VERIFY_LOGIN_INFORMATION.getString(new Object[0]), mathWorksServiceException.getMessage());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return releaseDataResponse;
    }

    @Override
    protected void apply(ReleaseDataResponse releaseDataResponse) {
        this.releaseDataResponse = releaseDataResponse;
    }

    @Override
    public ReleaseDataResponse getResults() {
        return this.releaseDataResponse;
    }
}

