/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_core_common.webservices.LeuData;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWAEntitledPerson;
import com.mathworks.internal.activationws.client.MWAGetPeopleResponse;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;

public class GetPeopleCallable
extends AbstractWebserviceCallable<MWAGetPeopleResponse, LeuData> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy client;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String locale;
    private String clientString;
    private String entitlementId;
    private String loggedInUsersEmailAddress;
    private LeuData leuData;

    public GetPeopleCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4, String string5) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.client = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string2;
        this.locale = string4;
        this.clientString = string5;
        this.entitlementId = string3;
        this.loggedInUsersEmailAddress = string;
        this.leuData = new LeuData("", "", "");
    }

    @Override
    protected void apply(MWAGetPeopleResponse mWAGetPeopleResponse) {
        MWAEntitledPerson mWAEntitledPerson;
        int n;
        if (mWAGetPeopleResponse != null && this.processResponse(mWAGetPeopleResponse) && (n = mWAGetPeopleResponse.getTotalCount()) == 1 && !this.loggedInUsersEmailAddress.equalsIgnoreCase((mWAEntitledPerson = mWAGetPeopleResponse.getPeople().getPeople()[0]).getEmailAddress())) {
            this.leuData = new LeuData(mWAEntitledPerson.getFirstName(), mWAEntitledPerson.getLastName(), mWAEntitledPerson.getEmailAddress());
        }
    }

    @Override
    protected MWAGetPeopleResponse callService() {
        int n = Integer.parseInt(this.entitlementId);
        try {
            return this.client.getPeople(this.token, n, this.locale, this.clientString);
        }
        catch (RemoteException remoteException) {
            this.exceptionHandler.handleException((Throwable)remoteException);
            return null;
        }
    }

    @Override
    public LeuData getResults() {
        return this.leuData;
    }

    private MWMessage[] getMessages(MWAGetPeopleResponse mWAGetPeopleResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWAGetPeopleResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWAGetPeopleResponse mWAGetPeopleResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAGetPeopleResponse)) {
            if (mWMessage.getSeverity() >= 2) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            throw MATLABInstallerExceptionUtil.getApplicationException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), mWMessage.getDescription(), string);
        }
        int n = mWAGetPeopleResponse.getResult();
        return n == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

