/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.Installer;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataRequest;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataResponse;
import com.mathworks.webservices.dws.client.rest.model.InstallerNames;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GetInstallerInDownloadOnlyCallable
extends AbstractWebserviceCallable<InstallerDataResponse, List<InstallerDownloadURLInfo>> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String securityToken;
    private final DWSRestClient dwsRestClient;
    private final String releaseString;
    private final List<String> installerNames;
    private AppLogger appLogger;
    private final List<InstallerDownloadURLInfo> installerDownloadURLInfos = new ArrayList<InstallerDownloadURLInfo>();

    public GetInstallerInDownloadOnlyCallable(String string, String string2, DWSRestClientProxy dWSRestClientProxy, ExceptionHandler exceptionHandler, List<String> list, AppLogger appLogger) {
        super((WebServiceClientProxy)dWSRestClientProxy, exceptionHandler);
        this.securityToken = string;
        this.clientString = string2;
        this.dwsRestClient = dWSRestClientProxy;
        this.installerNames = list;
        this.appLogger = appLogger;
        this.exceptionHandler = exceptionHandler;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    @Override
    protected InstallerDataResponse callService() throws RemoteException {
        InstallerDataResponse installerDataResponse = null;
        try {
            InstallerDataRequest installerDataRequest = new InstallerDataRequest();
            installerDataRequest.setRelease(this.releaseString);
            installerDataRequest.setTargetUpdateRelease(InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]));
            InstallerNames installerNames = new InstallerNames();
            installerNames.getName().addAll(this.installerNames);
            installerDataRequest.setInstallerNames(installerNames);
            installerDataResponse = this.dwsRestClient.getInstallers(Locale.getDefault().toString(), this.clientString, this.securityToken, installerDataRequest);
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(throwable);
        }
        return installerDataResponse;
    }

    @Override
    protected void apply(InstallerDataResponse installerDataResponse) {
        try {
            boolean bl;
            List list = installerDataResponse.getInstaller();
            String string = System.getenv(InstallCoreCommonResourceKeys.MW_ARCHIVE_LOCATION.getString(new Object[0]));
            String string2 = System.getenv(InstallCoreCommonResourceKeys.MW_INSTALLER_LOCATION.getString(new Object[0]));
            boolean bl2 = string != null && !string.isEmpty();
            boolean bl3 = bl = string2 != null && !string2.isEmpty();
            if (list.size() <= 0) {
                this.appLogger.logMsg("No URLs returned");
            } else if (this.installerNames.size() != list.size()) {
                this.appLogger.logMsg("No. of urls do not match the number of architectures");
                this.appLogger.logMsg("Installer names length: " + this.installerNames.size() + " Response Installer length: " + list.size());
            } else {
                if (bl2 && !bl) {
                    return;
                }
                for (Installer installer : list) {
                    URL uRL = new URL(installer.getUrl());
                    if (bl2 && bl) {
                        uRL = new File(string2 + File.separator + installer.getName()).toURI().toURL();
                    }
                    this.installerDownloadURLInfos.add(new InstallerDownloadURLInfo(installer.getName(), uRL));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.appLogger.logMsg(malformedURLException.getMessage());
        }
    }

    @Override
    public List<InstallerDownloadURLInfo> getResults() {
        return this.installerDownloadURLInfos;
    }
}

