/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWAEntitlement;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.internal.activationws.client.MWAGetEntitlementsResponse;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.InstallerEntitlementFactoryImpl;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class GetEntitlementCallable
extends AbstractWebserviceCallable<MWAGetEntitlementsResponse, InstallerEntitlement[]> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy activationServiceClient;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String release;
    private String locale;
    private String clientString;
    private InstallerEntitlement[] installerEntitlements;

    public GetEntitlementCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.activationServiceClient = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.release = string2;
        this.locale = string3;
        this.clientString = string4;
    }

    @Override
    protected void apply(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        if (mWAGetEntitlementsResponse != null && this.processResponse(mWAGetEntitlementsResponse)) {
            ArrayOfMWAEntitlement arrayOfMWAEntitlement = mWAGetEntitlementsResponse.getEntitlements();
            MWAEntitlement[] mWAEntitlementArray = arrayOfMWAEntitlement.getEntitlement();
            if (mWAEntitlementArray == null) {
                this.installerEntitlements = new InstallerEntitlement[0];
            } else {
                ArrayList<InstallerEntitlement> arrayList = new ArrayList<InstallerEntitlement>();
                for (MWAEntitlement mWAEntitlement : mWAEntitlementArray) {
                    arrayList.add(InstallerEntitlementFactoryImpl.createInstallerEntitlement((MWAEntitlement)mWAEntitlement));
                }
                this.installerEntitlements = arrayList.toArray(new InstallerEntitlement[arrayList.size()]);
            }
        }
    }

    @Override
    protected MWAGetEntitlementsResponse callService() {
        try {
            return this.activationServiceClient.getAllEntitlementsByControllingProduct(this.token, this.release, this.locale, this.clientString);
        }
        catch (RemoteException remoteException) {
            this.exceptionHandler.handleException((Throwable)remoteException);
            return null;
        }
    }

    @Override
    public InstallerEntitlement[] getResults() {
        return this.installerEntitlements;
    }

    private int getResult(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAGetEntitlementsResponse)) {
            if (mWMessage.getCode() != 676) continue;
            return 0;
        }
        return mWAGetEntitlementsResponse.getResult();
    }

    private boolean shouldDisplayError(MWMessage mWMessage) {
        return mWMessage.getSeverity() < 2 && mWMessage.getCode() != 676;
    }

    private MWMessage[] getMessages(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWAGetEntitlementsResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            for (MWMessage mWMessage : mWMessageArray) {
                if (mWMessage.getCode() != 676) continue;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAGetEntitlementsResponse)) {
            if (!this.shouldDisplayError(mWMessage)) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            throw MATLABInstallerExceptionUtil.getApplicationException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), mWMessage.getDescription(), string);
        }
        int n = this.getResult(mWAGetEntitlementsResponse);
        return n == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

