/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerException;
import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWAEntitlement;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.internal.activationws.client.MWAGetEntitlementsResponse;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.InstallerEntitlementFactoryImpl;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;

public class GetEntitlementByActivationKeyCallable
extends AbstractWebserviceCallable<MWAGetEntitlementsResponse, InstallerEntitlement> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy activationServiceClient;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String release;
    private String locale;
    private String clientString;
    private InstallerEntitlement installerEntitlement;
    private String activationKey;

    public GetEntitlementByActivationKeyCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4, String string5) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.activationServiceClient = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.release = string3;
        this.locale = string4;
        this.clientString = string5;
        this.activationKey = string2;
    }

    @Override
    protected void apply(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        if (mWAGetEntitlementsResponse != null && this.processResponse(mWAGetEntitlementsResponse)) {
            ArrayOfMWAEntitlement arrayOfMWAEntitlement = mWAGetEntitlementsResponse.getEntitlements();
            MWAEntitlement[] mWAEntitlementArray = arrayOfMWAEntitlement.getEntitlement();
            if (mWAEntitlementArray == null) {
                this.installerEntitlement = InstallerEntitlementFactoryImpl.createInstallerEntitlement();
            } else if (mWAEntitlementArray.length == 1) {
                this.installerEntitlement = InstallerEntitlementFactoryImpl.createInstallerEntitlement((MWAEntitlement)mWAEntitlementArray[0]);
            }
        }
    }

    @Override
    protected MWAGetEntitlementsResponse callService() {
        try {
            return this.activationServiceClient.getAllEntitlementByControllingProductAndActivationKey(this.token, this.activationKey, this.release, this.locale, this.clientString);
        }
        catch (RemoteException remoteException) {
            this.exceptionHandler.handleException((Throwable)remoteException);
            return null;
        }
    }

    @Override
    public InstallerEntitlement getResults() {
        return this.installerEntitlement;
    }

    private MWMessage[] getMessages(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWAGetEntitlementsResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWAGetEntitlementsResponse mWAGetEntitlementsResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAGetEntitlementsResponse)) {
            if (mWMessage.getSeverity() >= 2) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            MATLABInstallerException mATLABInstallerException = MATLABInstallerExceptionUtil.getValidationException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), InstallCoreCommonResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]) + " " + mWMessage.getCode() + ":" + InstallCoreCommonResourceKeys.INVALID_AK.getString(new Object[0]), string);
            this.showError(mATLABInstallerException);
        }
        return mWAGetEntitlementsResponse.getResult() == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

