/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.webserviceproxy.DDUXWSClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.ddux.client.installer.InstallerDDUXSettingsRequest;
import com.mathworks.webservices.ddux.client.installer.InstallerDDUXSettingsResponse;
import java.util.Locale;

public class GetDDUXSettingsCallable
extends AbstractWebserviceCallable<InstallerDDUXSettingsResponse, InstallerDDUXSettingsResponse> {
    private static final String APPLICATION_NAME = "installer";
    private static final String APPLICATION_VERSION = "2.0";
    private final DDUXWSClientProxy installerDDUXSettingsClient;
    private ExceptionHandler exceptionHandler;
    private final String token;
    private final String selectedEntitlementId;
    private InstallerDDUXSettingsResponse response;

    public GetDDUXSettingsCallable(DDUXWSClientProxy dDUXWSClientProxy, ExceptionHandler exceptionHandler, String string, String string2) {
        super((WebServiceClientProxy)dDUXWSClientProxy, exceptionHandler);
        this.installerDDUXSettingsClient = dDUXWSClientProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.selectedEntitlementId = string2;
    }

    @Override
    protected void apply(InstallerDDUXSettingsResponse installerDDUXSettingsResponse) {
        if (installerDDUXSettingsResponse != null) {
            UdcUtil udcUtil = UdcUtil.getInstance();
            udcUtil.setShouldShow(installerDDUXSettingsResponse.isShown());
            udcUtil.setIsChecked(installerDDUXSettingsResponse.isChecked());
            udcUtil.setIsSelectable(installerDDUXSettingsResponse.isSelectable());
        }
        this.response = installerDDUXSettingsResponse;
    }

    @Override
    protected InstallerDDUXSettingsResponse callService() {
        try {
            InstallerDDUXSettingsRequest installerDDUXSettingsRequest = new InstallerDDUXSettingsRequest();
            installerDDUXSettingsRequest.setEntitlementId(this.selectedEntitlementId);
            installerDDUXSettingsRequest.setApplication(APPLICATION_NAME);
            String string = InstutilResourceKeys.RELEASE.getBundleString();
            installerDDUXSettingsRequest.setApplicationVersion(string);
            installerDDUXSettingsRequest.setClientString("installer_2.0");
            installerDDUXSettingsRequest.setLocale(Locale.getDefault().toString());
            installerDDUXSettingsRequest.setSecurityToken(this.token);
            return this.installerDDUXSettingsClient.getSettings(installerDDUXSettingsRequest);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public InstallerDDUXSettingsResponse getResults() {
        return this.response;
    }
}

