/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWAProfileResponse;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;

public class CreateProfileForOtherCallable
extends AbstractWebserviceCallable<MWAProfileResponse, String> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy client;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String emailAddress;
    private String firstName;
    private String lastName;
    private String activationKey;
    private String localeString;
    private String clientString;
    private String securityToken;

    public CreateProfileForOtherCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.client = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.emailAddress = string2;
        this.firstName = string3;
        this.lastName = string4;
        this.activationKey = string5;
        this.localeString = string6;
        this.clientString = string7;
    }

    @Override
    protected void apply(MWAProfileResponse mWAProfileResponse) {
        if (mWAProfileResponse != null && this.processResponse(mWAProfileResponse)) {
            this.securityToken = mWAProfileResponse.getSecurityToken();
        }
    }

    @Override
    protected MWAProfileResponse callService() throws RemoteException {
        try {
            return this.client.createProfileForOther(this.token, this.emailAddress, this.firstName, this.lastName, this.activationKey, this.localeString, this.clientString);
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception);
            return null;
        }
    }

    @Override
    public String getResults() {
        return this.securityToken;
    }

    private MWMessage[] getMessages(MWAProfileResponse mWAProfileResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWAProfileResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWAProfileResponse mWAProfileResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAProfileResponse)) {
            if (mWMessage.getSeverity() >= 2) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            throw MATLABInstallerExceptionUtil.getApplicationException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), mWMessage.getDescription(), string);
        }
        int n = mWAProfileResponse.getResult();
        return n == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

