/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWACanActivateResponse;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;

public class CanActivateCallable
extends AbstractWebserviceCallable<MWACanActivateResponse, Boolean> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy activationServiceClient;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String release;
    private String locale;
    private String clientString;
    private String activationKey;
    private boolean activatable;

    public CanActivateCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4, String string5) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.activationServiceClient = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.release = string3;
        this.locale = string4;
        this.clientString = string5;
        this.activationKey = string2;
    }

    @Override
    protected void apply(MWACanActivateResponse mWACanActivateResponse) {
        if (mWACanActivateResponse != null && this.processResponse(mWACanActivateResponse)) {
            this.activatable = mWACanActivateResponse.getActivatable();
        }
    }

    @Override
    protected MWACanActivateResponse callService() {
        try {
            return this.activationServiceClient.canActivate(this.token, this.activationKey, this.release, this.locale, this.clientString);
        }
        catch (RemoteException remoteException) {
            this.exceptionHandler.handleException((Throwable)remoteException);
            return null;
        }
    }

    @Override
    public Boolean getResults() {
        return this.activatable;
    }

    private int getResult(MWACanActivateResponse mWACanActivateResponse) {
        for (MWMessage mWMessage : this.getMessages(mWACanActivateResponse)) {
            if (mWMessage.getCode() != 676) continue;
            return 0;
        }
        return mWACanActivateResponse.getResult();
    }

    private boolean shouldDisplayError(MWMessage mWMessage) {
        return mWMessage.getSeverity() < 2 && mWMessage.getCode() != 676;
    }

    private MWMessage[] getMessages(MWACanActivateResponse mWACanActivateResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWACanActivateResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWACanActivateResponse mWACanActivateResponse) {
        for (MWMessage mWMessage : this.getMessages(mWACanActivateResponse)) {
            if (!this.shouldDisplayError(mWMessage)) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            throw MATLABInstallerExceptionUtil.getApplicationException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), mWMessage.getDescription(), string);
        }
        int n = this.getResult(mWACanActivateResponse);
        return n == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

