/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_core_common.MATLABInstallerExceptionUtil;
import com.mathworks.install_core_common.resources.CommonDDUXResources;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.internal.activationws.client.ArrayOfMWMessage;
import com.mathworks.internal.activationws.client.MWAActivateResponse;
import com.mathworks.internal.activationws.client.MWAMachineAttribute;
import com.mathworks.internal.activationws.client.MWMessage;
import com.mathworks.mlwebservices.webserviceproxy.ActivationServiceProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import java.rmi.RemoteException;

public class ActivateSelfCallable
extends AbstractWebserviceCallable<MWAActivateResponse, String> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private ActivationServiceProxy client;
    private ExceptionHandler exceptionHandler;
    private String token;
    private String username;
    private String activationKey;
    private String lockingType;
    private MWAMachineAttribute[] mwaMachineAttributes;
    private String releaseString;
    private String osVersionString;
    private String archSting;
    private String localeString;
    private String clientString;
    private String licenseFileString;

    public ActivateSelfCallable(ActivationServiceProxy activationServiceProxy, ExceptionHandler exceptionHandler, String string, String string2, String string3, String string4, MWAMachineAttribute[] mWAMachineAttributeArray, String string5, String string6, String string7, String string8, String string9) {
        super((WebServiceClientProxy)activationServiceProxy, exceptionHandler);
        this.client = activationServiceProxy;
        this.exceptionHandler = exceptionHandler;
        this.token = string;
        this.username = string2;
        this.activationKey = string3;
        this.lockingType = string4;
        this.mwaMachineAttributes = mWAMachineAttributeArray;
        this.releaseString = string5;
        this.osVersionString = string6;
        this.archSting = string7;
        this.localeString = string8;
        this.clientString = string9;
    }

    @Override
    protected void apply(MWAActivateResponse mWAActivateResponse) {
        if (mWAActivateResponse != null && this.processResponse(mWAActivateResponse)) {
            this.licenseFileString = mWAActivateResponse.getLicenseFileString();
        }
    }

    @Override
    protected MWAActivateResponse callService() throws RemoteException {
        try {
            return this.client.activateSelf(this.token, this.username, this.activationKey, this.lockingType, this.mwaMachineAttributes, this.releaseString, this.osVersionString, this.archSting, this.localeString, this.clientString);
        }
        catch (RemoteException remoteException) {
            this.exceptionHandler.handleException((Throwable)remoteException);
            return null;
        }
    }

    @Override
    public String getResults() {
        return this.licenseFileString;
    }

    private MWMessage[] getMessages(MWAActivateResponse mWAActivateResponse) {
        ArrayOfMWMessage arrayOfMWMessage = mWAActivateResponse.getMessages();
        if (arrayOfMWMessage != null) {
            MWMessage[] mWMessageArray = arrayOfMWMessage.getMessage();
            if (mWMessageArray == null) {
                return EMPTY_MESSAGE_ARRAY;
            }
            return mWMessageArray;
        }
        return EMPTY_MESSAGE_ARRAY;
    }

    private boolean processResponse(MWAActivateResponse mWAActivateResponse) {
        for (MWMessage mWMessage : this.getMessages(mWAActivateResponse)) {
            if (mWMessage.getSeverity() >= 2) continue;
            String string = CommonDDUXResources.WEB_SERVICE_ERROR.getString() + mWMessage.getDescription();
            throw MATLABInstallerExceptionUtil.getWebServiceException(InstallCoreCommonResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), mWMessage.getDescription(), string);
        }
        int n = mWAActivateResponse.getResult();
        return n == 0;
    }

    private void showError(Throwable throwable) {
        this.exceptionHandler.handleException(throwable);
    }
}

