/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.client.core.MathWorksClientException;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;

abstract class AbstractWebserviceCallable<R, V>
implements Callable<Boolean> {
    private WebServiceClientProxy client;
    private ExceptionHandler exceptionHandler;

    protected AbstractWebserviceCallable(WebServiceClientProxy webServiceClientProxy, ExceptionHandler exceptionHandler) {
        this.client = webServiceClientProxy;
        this.exceptionHandler = exceptionHandler;
    }

    public V doCall() {
        this.call();
        return this.getResults();
    }

    @Override
    public Boolean call() {
        try {
            this.client.configureProxies();
            R r = this.callService();
            this.apply(r);
            return true;
        }
        catch (MathWorksClientException mathWorksClientException) {
            this.processMathWorksClientException(mathWorksClientException);
            return false;
        }
        catch (Exception exception) {
            this.processException(exception);
            return false;
        }
    }

    protected void processMathWorksClientException(MathWorksClientException mathWorksClientException) {
        this.exceptionHandler.handleException((Throwable)mathWorksClientException);
    }

    protected void processException(Exception exception) {
        this.exceptionHandler.handleException((Throwable)exception);
    }

    protected abstract void apply(R var1);

    protected abstract R callService() throws RemoteException;

    public abstract V getResults();
}

