/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.webservices;

import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install_core_common.webservices.AbstractWebserviceCallable;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.Component;
import com.mathworks.webservices.dws.client.rest.model.ComponentDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ComponentId;
import com.mathworks.webservices.dws.client.rest.model.ComponentIds;
import com.mathworks.webservices.dws.client.rest.model.ReleaseData;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractGetComponentsCallable
extends AbstractWebserviceCallable<Boolean, Boolean> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String securityToken;
    private final DWSRestClient dwsRestClient;
    private final ReleaseData[] releaseDataArray;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final IO io;
    private final String releaseString;
    private boolean getUpdatesResponse;
    private final String DWSZIPERROR = "DWSZipError";

    AbstractGetComponentsCallable(String string, String string2, ReleaseData[] releaseDataArray, Downloader downloader, ProxyConfiguration proxyConfiguration, DWSRestClientProxy dWSRestClientProxy, IO iO, ExceptionHandler exceptionHandler) {
        super((WebServiceClientProxy)dWSRestClientProxy, exceptionHandler);
        this.securityToken = string;
        this.clientString = string2;
        this.releaseDataArray = releaseDataArray;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.dwsRestClient = dWSRestClientProxy;
        this.io = iO;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean callService() throws RemoteException {
        try {
            MyComponentURLProvider myComponentURLProvider = new MyComponentURLProvider(this.clientString, Locale.getDefault().toString());
            for (ReleaseData releaseData : this.releaseDataArray) {
                File file = null;
                try {
                    file = File.createTempFile("dwsZipFile", null);
                    URL uRL = new URL(releaseData.getUrl());
                    this.downloader.download(this.proxyConfiguration, uRL, file, new IOObserver[0]);
                    myComponentURLProvider.setReleaseId(releaseData.getReleaseId());
                    this.addReleaseData(file, myComponentURLProvider);
                }
                finally {
                    this.io.deleteFile(file);
                }
            }
            myComponentURLProvider.doCall();
            return true;
        }
        catch (Throwable throwable) {
            Exception exception = new Exception("DWSZipError");
            this.exceptionHandler.handleException((Throwable)exception);
            return false;
        }
    }

    protected abstract void addReleaseData(File var1, MyComponentURLProvider var2);

    @Override
    protected void apply(Boolean bl) {
        this.getUpdatesResponse = bl;
    }

    @Override
    public Boolean getResults() {
        return this.getUpdatesResponse;
    }

    private String getComponentPath(Component component) {
        String string = component.getComponentId().getName();
        if (string.contains("_doc_ja")) {
            return "doc_ja";
        }
        if (string.contains("_doc_ko_KR")) {
            return "doc_ko";
        }
        if (string.contains("_doc_zh_CN")) {
            return "doc_zh";
        }
        if (string.contains("_common")) {
            return "common";
        }
        if (string.contains("_glnxa64")) {
            return "glnxa64";
        }
        if (string.contains("_maci64")) {
            return "maci64";
        }
        if (string.contains("_win32")) {
            return "win32";
        }
        if (string.contains("_win64")) {
            return "win64";
        }
        return "";
    }

    protected class MyComponentURLProvider
    implements ComponentURLProvider {
        private final String clientString;
        private final String localeString;
        private final Collection<ComponentId> componentIdsList = new ArrayList<ComponentId>();
        private final Map<String, String> componentIdToURLMap = new HashMap<String, String>();
        private String releaseId;

        MyComponentURLProvider(String string, String string2) {
            this.clientString = string;
            this.localeString = string2;
        }

        private void doCall() throws MathWorksClientException, MathWorksServiceException {
            ComponentIds componentIds;
            ComponentDataRequest componentDataRequest = new ComponentDataRequest();
            componentDataRequest.setRelease(AbstractGetComponentsCallable.this.releaseString);
            if (!this.componentIdsList.isEmpty()) {
                componentIds = new ComponentIds();
                componentIds.getComponentId().addAll(this.componentIdsList);
                componentDataRequest.setComponentIds(componentIds);
            }
            componentIds = AbstractGetComponentsCallable.this.dwsRestClient.getComponents(this.localeString, this.clientString, AbstractGetComponentsCallable.this.securityToken, componentDataRequest);
            List list = componentIds.getComponent();
            String string = System.getenv("MW_ARCHIVE_LOCATION_TO_COPY_FROM");
            boolean bl = string != null && !string.isEmpty();
            for (Component component : list) {
                File file;
                ComponentId componentId = component.getComponentId();
                String string2 = componentId.getName();
                String string3 = componentId.getVersion();
                String string4 = component.getComponentUrl();
                if (bl && !(file = new File(string + File.separator + AbstractGetComponentsCallable.this.getComponentPath(component) + File.separator + this.getKey(string2, string3) + ".enc")).isFile()) {
                    try {
                        string4 = file.toURI().toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.componentIdToURLMap.put(this.getKey(string2, string3), string4);
            }
        }

        public String getURL(String string, String string2) {
            return this.componentIdToURLMap.get(this.getKey(string, string2));
        }

        private String getKey(String string, String string2) {
            return string + "_" + string2;
        }

        public void add(String string, String string2) {
            ComponentId componentId = new ComponentId();
            componentId.setCurrentUpdateRelease(this.releaseId);
            ReleaseData[] releaseDataArray = AbstractGetComponentsCallable.this.releaseDataArray;
            String string3 = releaseDataArray[0].getReleaseId();
            componentId.setTargetUpdateRelease(string3);
            componentId.setName(string);
            componentId.setVersion(string2);
            this.componentIdsList.add(componentId);
        }

        public void setReleaseId(String string) {
            this.releaseId = string;
        }
    }
}

