/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.util;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.instutil.IO;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class InstallCoreCommonUtil {
    private static final String SEP = System.getProperty("line.separator");
    private static final String PRODUCT_PROPERTY_PREFIX = "product.";

    public static String getSLAText(IO iO) throws IOException {
        String string = InstallCoreCommonResourceKeys.MATLAB_LICENSE_AGREEMENT.getString(new Object[0]);
        ClassLoader classLoader = InstallCoreCommonUtil.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        String string2 = iO.getResourceFromFile(uRL);
        return string2;
    }

    public static String getPatentsAndTrademarksText() {
        return InstallCoreCommonResourceKeys.MATHWORKS_PATENTS_TEXT.getString(new Object[0]) + SEP + SEP + InstallCoreCommonResourceKeys.MATHWORKS_TRADEMARKS_TEXT.getString(new Object[0]);
    }

    public static void updateAvailableProductsWithInstalled(Collection<AvailableProduct> collection, List<AvailableProduct> list, Properties properties) {
        for (AvailableProduct availableProduct : collection) {
            boolean bl = list.contains(availableProduct);
            availableProduct.setInstalled(bl);
            if (!bl || properties.containsKey(InstallCoreCommonUtil.getPropertyName(availableProduct))) continue;
            availableProduct.setSelected(false);
        }
    }

    private static String getPropertyName(AvailableProduct availableProduct) {
        return PRODUCT_PROPERTY_PREFIX + availableProduct.getName().replaceAll("[ -]", "_");
    }
}

