/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.util;

import com.mathworks.install.Product;
import com.mathworks.install_core_common.util.DependencyChecker;
import com.mathworks.instutil.VersionUtils;
import java.util.LinkedHashSet;

public final class DependencyCheckerImpl
implements DependencyChecker {
    @Override
    public Product[] checkMissingControllingProducts(Product[] productArray, Product[] productArray2) {
        LinkedHashSet<Product> linkedHashSet = new LinkedHashSet<Product>();
        for (Product product : productArray) {
            if (product.isControlling()) {
                if (DependencyCheckerImpl.isDependencyMatched(product, productArray2)) break;
                linkedHashSet.add(product);
            }
            if (!linkedHashSet.isEmpty()) break;
        }
        return linkedHashSet.toArray(new Product[linkedHashSet.size()]);
    }

    @Override
    public Product[] checkMissingRequiredProducts(Product[] productArray, Product[] productArray2) {
        LinkedHashSet<Product> linkedHashSet = new LinkedHashSet<Product>();
        for (Product product : productArray) {
            if (DependencyCheckerImpl.isDependencySatisfied(product, productArray2)) continue;
            linkedHashSet.add(product);
        }
        return linkedHashSet.toArray(new Product[linkedHashSet.size()]);
    }

    public static boolean satisfiesDependency(Product product, Product product2) {
        return DependencyCheckerImpl.matchesDependency(product, product2) && VersionUtils.compareVersionNumbers((String)product.getVersion(), (String)product2.getVersion()) > -1;
    }

    public static boolean matchesDependency(Product product, Product product2) {
        return product.getProductNumber() == product2.getProductNumber();
    }

    private static boolean isDependencySatisfied(Product product, Product[] productArray) {
        for (Product product2 : productArray) {
            if (!DependencyCheckerImpl.satisfiesDependency(product2, product)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDependencyMatched(Product product, Product[] productArray) {
        for (Product product2 : productArray) {
            if (!DependencyCheckerImpl.matchesDependency(product2, product)) continue;
            return true;
        }
        return false;
    }
}

