/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common.util;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.webservices.dws.client.rest.model.EntitledProduct;

public class DWSEnabledValidatedFik
implements ValidatedFik {
    private final ValidatedFik inner;
    private final EntitledProduct[] entitledProducts;

    public DWSEnabledValidatedFik(ValidatedFik validatedFik, EntitledProduct[] entitledProductArray) {
        this.inner = validatedFik;
        this.entitledProducts = (EntitledProduct[])entitledProductArray.clone();
    }

    public String get() {
        return this.inner.get();
    }

    public boolean canActivate() {
        return this.inner.canActivate();
    }

    public boolean canInstall(Product product, long l) {
        if (this.inner.canInstall(product, l)) {
            if (l == 0L) {
                return true;
            }
            for (EntitledProduct entitledProduct : this.entitledProducts) {
                if (entitledProduct.getBitNumber() != product.getProductNumber() || VersionUtils.compareVersionNumbers((String)entitledProduct.getVersion(), (String)product.getVersion()) <= -1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean requiresLicenseFile() {
        return this.inner.requiresLicenseFile();
    }

    public boolean isJITEnabledFik() {
        return this.inner.isJITEnabledFik();
    }

    public boolean isTEUEnabledFik() {
        return this.inner.isTEUEnabledFik();
    }

    public Integer[] getProducts() {
        return this.inner.getProducts();
    }
}

