/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.Product;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

final class MatlabFileAssociationsCommand
implements Command {
    static final String SET_FILE_ASSOC = "setFileAssoc";
    private final CommandFactory commandFactory;
    private final Properties properties;
    private final int[] productCodes;

    MatlabFileAssociationsCommand(CommandFactory commandFactory, Product[] productArray, Properties properties) {
        this.commandFactory = commandFactory;
        this.properties = new Properties(properties);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Product product : productArray) {
            arrayList.add(product.getProductNumber());
        }
        this.productCodes = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.productCodes[i] = (Integer)arrayList.get(i);
        }
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        if (Boolean.valueOf(this.properties.getProperty(SET_FILE_ASSOC, "true")).booleanValue()) {
            this.commandFactory.createFileAssociationsCommand(this.productCodes).execute(string, file, installFlowControlHandler);
        }
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.commandFactory.createFileAssociationsCommand(this.productCodes).undo(string, file, installFlowControlHandler);
    }
}

