/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_core_common;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.BooleanHolder;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.Product;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.command.PathdefGeneratorCommand;
import com.mathworks.install.condition.Condition;
import com.mathworks.install.exception.ExceptionLevel;
import com.mathworks.install.exception.InstallerRequirementNotSatisfiedException;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.service.ScheduledTaskParameters;
import com.mathworks.install.service.Service;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install_core_common.AbstractMathworksInstallConfiguration;
import com.mathworks.install_core_common.MatlabFileAssociationsCommand;
import com.mathworks.install_core_common.MatlabPreloaderScheduledTaskParameters;
import com.mathworks.install_core_common.ProductConditions;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKey;
import com.mathworks.install_core_common.resources.InstallCoreCommonResourceKeys;
import com.mathworks.install_impl.AbstractInstallOption;
import com.mathworks.install_impl.DisplayCommandErrorHandler;
import com.mathworks.install_impl.condition.ArchConditions;
import com.mathworks.install_impl.condition.ControllingProductCondition;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public abstract class AbstractMatlabInstallCommonConfiguration
extends AbstractMathworksInstallConfiguration {
    protected static final String RELEASE_STRING = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    private static final String LOCATION_TO_EXECUTABLE_SUBKEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\";
    private static final String MATLAB_EXE = "matlab.exe";
    private static final String ACTIVATE_MATLAB_EXE = "activate_matlab.exe";
    private static final String DEACTIVATE_MATLAB_EXE = "deactivate_matlab.exe";
    private static final String CREATE_ACCEL_TASK = "createAccelTask";
    private static final InstallOption[] NO_INSTALL_OPTIONS = new InstallOption[0];
    private static final String MPS_APPLICATION_NAME = "MATLAB Production Server";
    private static final String MATLAB_APPLICATION_NAME = "MATLAB";
    private static final String BFD_APPLICATION_NAME = "Polyspace";
    private static final String BFS_APPLICATION_NAME = "Polyspace Server";
    private static final String MATLAB_COMMENTS = InstallResourceKeys.MATLAB_SHORTCUT_COMMENTS.getString(new Object[0]);
    private static final String PATH_TO_EXE = "bin";
    private static final String POLYSPACE_EXE = "polyspace.exe";
    private static final String POLYSPACE_COMMENTS = InstallResourceKeys.POLYSPACE_COMMENTS.getString(new Object[0]);
    private static final String RELATIVE_PATH_TO_POLYSPACE_EXE = "polyspace" + File.separator + "bin";
    private static final String PATH_DEF_M = "pathdef.m";
    private static final int COMPILER_SDK = 97;
    private static final int LICENSE_MANAGER = 0;
    private static final int SIMULINK_CODER = 14;
    private static final int XPC_TARGET = 56;
    private static final int MATLAB_CODER = 135;
    private static final int STATEFLOW = 38;
    private static final int SIMULINK_TEST = 144;
    private static final int SIMULINK = 2;
    private static final int COMPILER = 28;
    private static final int SIMBIOLOGY = 103;
    private static final int FIXED_POINT_TOOLBOX = 91;
    private static final int MATLAB_DISTRIBUTED_COMPUTING_SERVER = 94;
    private static final String DISTRIBUTED_COMPUTING_LOCATION_IDENTIFIER = "dc";
    private static final int MATLAB_PRODUCTION_SERVER = 126;
    private static final int[] PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS64 = new int[]{14, 56, 135};
    private static final int[] PRODUCTS_REQUIRING_COMPILER = new int[]{38, 14, 56, 135, 144};
    private static final int[] PRODUCTS_RECOMMENDING_COMPILER = new int[]{103, 91};
    private BooleanHolder isPathTooLong = new BooleanHolder(false);

    private static void addFileAssociationsCommand(Product[] productArray, Collection<Command> collection, CommandFactory commandFactory, Properties properties) {
        collection.add(new MatlabFileAssociationsCommand(commandFactory, productArray, properties));
    }

    private static void addPathdefGeneratorCommand(final IO iO, Collection<Command> collection) {
        collection.add(new Command(){

            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
                new PathdefGeneratorCommand(iO, file.getAbsolutePath(), AbstractMatlabInstallCommonConfiguration.PATH_DEF_M).execute(string, file, installFlowControlHandler);
            }

            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
            }
        });
    }

    private static void addStopMatlabPreloaderCommand(CommandFactory commandFactory, ServiceFactory serviceFactory, Collection<Command> collection, String string, Collection<? extends Product> collection2) {
        if (AbstractMatlabInstallCommonConfiguration.notPolyspaceFamily(string, collection2)) {
            Service service = serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters());
            collection.add(commandFactory.createStopServicesCommand(new Service[]{service}));
        }
    }

    private static boolean notPolyspaceFamily(String string, Collection<? extends Product> collection) {
        return !ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, collection) && !ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, collection) && !ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, collection) && !ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, collection);
    }

    private static void addInstallMatlabPreloaderCommand(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory, Properties properties) {
        Service service = serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters());
        Command command = commandFactory.createInstallServicesCommand(new Service[]{service});
        if (ProductConditions.MATLAB.isSatisfied(string, collection) && !ProductConditions.MATLAB_DISTRIBUTED_COMPUTING_ENGINE.isSatisfied(string, collection) && AbstractMatlabInstallCommonConfiguration.notPolyspaceFamily(string, collection) && Boolean.valueOf(properties.getProperty(CREATE_ACCEL_TASK, "true")).booleanValue()) {
            collection2.add(command);
        }
    }

    private static String buildPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(File.separator);
        }
        return stringBuilder.toString();
    }

    protected static boolean licenseManagerServiceSelected(InstallOption[] installOptionArray) {
        for (InstallOption installOption : installOptionArray) {
            if (!InstallOptionType.LICENSE_SERVICE.equals((Object)installOption.getType()) || !installOption.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsProduct(AvailableProduct[] availableProductArray, int n) {
        for (AvailableProduct availableProduct : availableProductArray) {
            if (!AbstractMatlabInstallCommonConfiguration.productWasInstalledAndMatchesProductNumber(n, availableProduct)) continue;
            return true;
        }
        return false;
    }

    protected static boolean productWasInstalledAndMatchesProductNumber(int n, AvailableProduct availableProduct) {
        return availableProduct.canInstall() && availableProduct.getProductNumber() == n;
    }

    private static File getFullPathToExe(File file) {
        return new File(new File(file, PATH_TO_EXE), MATLAB_EXE);
    }

    private static String getExeKey(File file) {
        return LOCATION_TO_EXECUTABLE_SUBKEY + file.getName();
    }

    protected static void addNote(Collection<String> collection, String string, String ... stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(collection.size() + 1);
        arrayList.addAll(Arrays.asList(stringArray));
        collection.add(MessageFormat.format(string, arrayList.toArray()));
    }

    private static void addCompilerRequiredNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WIN64.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallCommonConfiguration.addCompilerNote(availableProductArray, InstallCoreCommonResourceKeys.SETUP_COMPILER_REQUIRED, PRODUCTS_REQUIRING_COMPILER_ON_WINDOWS64, collection, string);
        } else {
            AbstractMatlabInstallCommonConfiguration.addCompilerNote(availableProductArray, InstallCoreCommonResourceKeys.SETUP_COMPILER_REQUIRED, PRODUCTS_REQUIRING_COMPILER, collection, string);
        }
    }

    private static void addCompilerRecommendedNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        AbstractMatlabInstallCommonConfiguration.addCompilerNote(availableProductArray, InstallCoreCommonResourceKeys.SETUP_COMPILER_RECOMMENDED, PRODUCTS_RECOMMENDING_COMPILER, collection, string);
    }

    private static void addMDCSNote(AvailableProduct[] availableProductArray, Collection<String> collection, HyperlinkProvider hyperlinkProvider) {
        if (AbstractMatlabInstallCommonConfiguration.containsProduct(availableProductArray, 94)) {
            AbstractMatlabInstallCommonConfiguration.addNote(collection, InstallCoreCommonResourceKeys.SETUP_MDCE.getString(new Object[0]), hyperlinkProvider.getCustomLink(DISTRIBUTED_COMPUTING_LOCATION_IDENTIFIER));
        }
    }

    private static void addMPSNote(AvailableProduct[] availableProductArray, File file, Collection<String> collection, String string) {
        if (AbstractMatlabInstallCommonConfiguration.containsProduct(availableProductArray, 126)) {
            AbstractMatlabInstallCommonConfiguration.addNote(collection, InstallCoreCommonResourceKeys.SETUP_MPS.getString(new Object[0]), file.getAbsolutePath() + File.separator, RELEASE_STRING, string);
        }
    }

    private static void addMatlabCompilerNotes(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WIN64.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallCommonConfiguration.getNotesWithProductInfo(availableProductArray, collection, 28, InstallCoreCommonResourceKeys.SETUP_COMPILER_WIN);
        }
    }

    private static void addMatlabCompilerSDKNotes(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (ArchConditions.WIN64.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallCommonConfiguration.getNotesWithProductInfo(availableProductArray, collection, 97, InstallCoreCommonResourceKeys.SETUP_COMPILER_SDK_WIN);
        } else {
            AbstractMatlabInstallCommonConfiguration.getNotesWithProductInfo(availableProductArray, collection, 97, InstallCoreCommonResourceKeys.SETUP_COMPILER_SDK_GLNX64);
        }
    }

    private static void addCompilerNote(AvailableProduct[] availableProductArray, InstallCoreCommonResourceKey installCoreCommonResourceKey, int[] nArray, Collection<String> collection, String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            for (AvailableProduct availableProduct : availableProductArray) {
                if (!AbstractMatlabInstallCommonConfiguration.productWasInstalledAndMatchesProductNumber(n, availableProduct)) continue;
                stringBuilder.append("<br>").append(availableProduct.getName());
                bl = true;
            }
        }
        if (bl) {
            AbstractMatlabInstallCommonConfiguration.addNote(collection, installCoreCommonResourceKey.getString(collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallCommonConfiguration.getCompilerLink(), stringBuilder.toString()), new String[0]);
        }
    }

    private static void getNotesWithProductInfo(AvailableProduct[] availableProductArray, Collection<String> collection, int n, InstallCoreCommonResourceKey installCoreCommonResourceKey) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AvailableProduct availableProduct : availableProductArray) {
            if (!availableProduct.canInstall() || availableProduct.getProductNumber() != n) continue;
            stringBuilder.append(availableProduct.getName());
            AbstractMatlabInstallCommonConfiguration.addNote(collection, installCoreCommonResourceKey.getString(collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallCommonConfiguration.getCompilerLink(), stringBuilder.toString()), new String[0]);
        }
    }

    protected static String getCompilerLink() {
        return InstallCoreCommonResourceKeys.SETUP_COMPILER_ARCH.getString(new Object[0]);
    }

    public final String getDefaultDirectoryName(Platform platform, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(platform.getArchString(), list)) {
            return MPS_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName());
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(platform.getArchString(), list) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(platform.getArchString(), list)) {
            return BFD_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName());
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(platform.getArchString(), list) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(platform.getArchString(), list)) {
            return BFS_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName());
        }
        return this.getDefaultDirectoryName();
    }

    protected abstract String getDefaultDirectoryName();

    public final Command[] createStartMenuShortcutCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string = platform.getArchString();
        arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE, MATLAB_EXE, InstallResourceKeys.MATLAB_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), this.getStartMenuFolder(), RELEASE_STRING, MATLAB_COMMENTS, true, true));
        arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE + File.separator + string, ACTIVATE_MATLAB_EXE, InstallResourceKeys.ACTIVATE_MATLAB.getString(new Object[]{RELEASE_STRING}), this.getStartMenuFolder(), RELEASE_STRING, "", false, false));
        arrayList.addAll(Arrays.asList(this.createAdditionalStartMenuShortcutCommands(string, commandFactory, this.getStartMenuFolder())));
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final Command[] createStartMenuShortcutForPolyspaceCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string = platform.getArchString();
        arrayList.add(commandFactory.createStartMenuShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_EXE, InstallResourceKeys.POLYSPACE_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), this.getStartMenuFolderForPolyspace(), RELEASE_STRING, POLYSPACE_COMMENTS, false, true));
        arrayList.add(commandFactory.createStartMenuShortcutCommand(PATH_TO_EXE + File.separator + string, ACTIVATE_MATLAB_EXE, InstallResourceKeys.ACTIVATE_POLYSPACE.getString(new Object[]{RELEASE_STRING}), this.getStartMenuFolderForPolyspace(), RELEASE_STRING, "", false, false));
        arrayList.add(commandFactory.createStartMenuShortcutCommand("uninstall" + File.separator + PATH_TO_EXE + File.separator + string, DEACTIVATE_MATLAB_EXE, InstallResourceKeys.DEACTIVATE_POLYSPACE.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0])}), this.getStartMenuFolderForPolyspace(), RELEASE_STRING, "", false, false));
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    protected abstract Command[] createAdditionalStartMenuShortcutCommands(String var1, CommandFactory var2, String var3);

    public final Command[] createDesktopShortcutCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{commandFactory.createDesktopShortcutCommand(PATH_TO_EXE, MATLAB_EXE, InstallResourceKeys.MATLAB_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), RELEASE_STRING, MATLAB_COMMENTS, true)};
    }

    public final Command[] createDesktopShortcutForPolyspaceCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{commandFactory.createDesktopShortcutCommand(RELATIVE_PATH_TO_POLYSPACE_EXE, POLYSPACE_EXE, InstallResourceKeys.POLYSPACE_SHORTCUT.getString(new Object[]{this.getReleaseAndVersionString()}), RELEASE_STRING, POLYSPACE_COMMENTS, false)};
    }

    @Override
    public final String getUninstallProgramsEntryVersion(String string, Collection<? extends Product> collection) {
        return this.getVersion(string, collection);
    }

    @Override
    protected final String getUninstallProgramsEntryDisplayName(String string, Collection<Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return InstallResourceKeys.MPS_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, collection)) {
            return InstallResourceKeys.POLYSPACE_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, collection)) {
            return InstallResourceKeys.POLYSPACE_SERVER_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
        }
        return InstallResourceKeys.MATLAB_UNINSTALL_PROGRAMS_ENTRY.getString(new Object[]{this.getReleaseAndVersionString()});
    }

    public final String getInstallationPath(String string) {
        return string;
    }

    public final String getDefaultInstallationDirectory(Platform platform, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(platform.getArchString(), list)) {
            return MATLAB_APPLICATION_NAME.concat(File.separator).concat(MPS_APPLICATION_NAME).replaceAll(" ", "_").concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(platform.getArchString(), list) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(platform.getArchString(), list)) {
            return BFD_APPLICATION_NAME.replaceAll(" ", "_").concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(platform.getArchString(), list) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(platform.getArchString(), list)) {
            return BFS_APPLICATION_NAME.replaceAll(" ", "_").concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        if (platform.isLinux()) {
            return MATLAB_APPLICATION_NAME.concat(File.separator).concat(this.getDefaultDirectoryName().replaceAll(" ", "_"));
        }
        return "MATLAB_".concat(this.getDefaultDirectoryName().replaceAll(" ", "_")).concat(".app");
    }

    public final void deactivateInstallation(String string, Product[] productArray, String[] stringArray) {
        List<Product> list = Arrays.asList(productArray);
        if (new ControllingProductCondition().isSatisfied(string, list) && !ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            this.deactivateInstallation(stringArray);
        }
    }

    public final String getUsageId(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            return "mps_" + this.getUsageId();
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, list)) {
            return BFD_APPLICATION_NAME;
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, list)) {
            return BFS_APPLICATION_NAME;
        }
        return this.getUsageId();
    }

    protected abstract String getUsageId();

    public final String getUsageString(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list)) {
            return this.getUsageString(MPS_APPLICATION_NAME);
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, list)) {
            return BFD_APPLICATION_NAME;
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, list)) {
            return BFS_APPLICATION_NAME;
        }
        return this.getUsageString();
    }

    protected abstract String getUsageString(String var1);

    protected abstract String getUsageString();

    protected abstract void deactivateInstallation(String[] var1);

    @Override
    public final Command[] getAdditionalPostUninstallCommands(String string, Product[] productArray, CommandFactory commandFactory, final IO iO) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(new Command(){

            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
            }

            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
                new PathdefGeneratorCommand(iO, file.getAbsolutePath(), AbstractMatlabInstallCommonConfiguration.PATH_DEF_M).undo(string, file, installFlowControlHandler);
            }
        });
        arrayList.add(commandFactory.createSharedDocCommand());
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final boolean shouldAllowFolderChangeIfAlreadyInstalled(Platform platform) {
        return true;
    }

    public final boolean canChooseTypicalOrCustom() {
        return true;
    }

    public final boolean canChangeFolder(Platform platform, Registry registry, Installer installer) {
        return true;
    }

    public final InstallOption[] getUninstallOptions(String string, Product[] productArray, InstallOption ... installOptionArray) {
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, list) || ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, list)) {
            return NO_INSTALL_OPTIONS;
        }
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>(Arrays.asList(installOptionArray));
        arrayList.add((InstallOption)new AbstractInstallOption(null, true, InstallOptionType.CUSTOM){

            public Command[] getCommands(CommandFactory commandFactory, ServiceFactory serviceFactory) {
                return new Command[]{commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createScheduledTask((ScheduledTaskParameters)new MatlabPreloaderScheduledTaskParameters())})};
            }
        });
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    @Override
    protected final String getPathToRegister(String string) {
        return string;
    }

    @Override
    protected final void checkAdditionalInstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        this.checkAdditionalMatlabInstallerRequirements(installerRequirements);
    }

    protected abstract void checkAdditionalMatlabInstallerRequirements(InstallerRequirements var1) throws InstallerRequirementNotSatisfiedException;

    @Override
    protected final void checkAdditionalUninstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
        if (installerRequirements.anyMatlabRunning()) {
            throw new InstallerRequirementNotSatisfiedException(ExceptionLevel.ERROR, InstallCoreCommonResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]), InstallCoreCommonResourceKeys.SHUTDOWN_MATLAB_TEXT.getString(new Object[0]));
        }
    }

    @Override
    public final String getApplicationVersion(String string, Collection<? extends Product> collection) {
        return this.getVersion(string, collection);
    }

    private String getVersion(String string, Collection<? extends Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return InstutilResourceKeys.MPSVERSION.getString(new Object[0]);
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, collection) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, collection)) {
            return InstutilResourceKeys.BFDVERSION.getString(new Object[0]);
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, collection) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, collection)) {
            return InstutilResourceKeys.BFSVERSION.getString(new Object[0]);
        }
        return InstutilResourceKeys.MATLABVERSION.getString(new Object[0]);
    }

    public final Command[] getPreInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        this.addDistributedComputingToolboxPreInstall(string, list, arrayList, commandFactory, serviceFactory);
        this.addLicenseManagerPreInstall(string, list, arrayList, commandFactory, serviceFactory);
        this.addMATLABDistributedComputingEnginePreInstall(string, list, arrayList, commandFactory, serviceFactory);
        AbstractMatlabInstallCommonConfiguration.addStopMatlabPreloaderCommand(commandFactory, serviceFactory, arrayList, string, list);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    @Override
    protected final Command[] getAdditionalPostInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory, IO iO, Properties properties) {
        String string2 = AbstractMatlabInstallCommonConfiguration.buildPath(PATH_TO_EXE, string);
        String string3 = AbstractMatlabInstallCommonConfiguration.buildPath("runtime", string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string2);
        ArrayList<Command> arrayList3 = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        this.addCompilerSDK(string, list, arrayList3, commandFactory);
        this.addMATLAB(string, list, arrayList3, commandFactory, arrayList2);
        this.addPolyspace(string, list, arrayList3, commandFactory);
        this.addMATLABCompiler(string, list, arrayList3, commandFactory, string3, string2, arrayList);
        AbstractMatlabInstallCommonConfiguration.addInstallMatlabPreloaderCommand(string, list, arrayList3, commandFactory, serviceFactory, properties);
        AbstractMatlabInstallCommonConfiguration.addPathdefGeneratorCommand(iO, arrayList3);
        AbstractMatlabInstallCommonConfiguration.addFileAssociationsCommand(productArray, arrayList3, commandFactory, properties);
        arrayList3.add(commandFactory.createSharedDocCommand());
        arrayList3.addAll(Arrays.asList(this.getAdditionalPostInstallCommands(string, list.toArray(new Product[list.size()]), iO, properties, commandFactory)));
        return arrayList3.toArray(new Command[arrayList3.size()]);
    }

    @Override
    protected final String getUninstallProgramsEntryName(String string, Collection<Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return this.getUninstallProgramsEntryName(MPS_APPLICATION_NAME);
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, collection)) {
            return this.getUninstallProgramsEntryName(BFD_APPLICATION_NAME);
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, collection)) {
            return this.getUninstallProgramsEntryName(BFS_APPLICATION_NAME);
        }
        return this.getUninstallProgramsEntryName("Matlab");
    }

    protected abstract String getUninstallProgramsEntryName(String var1);

    protected abstract Command[] getAdditionalPostInstallCommands(String var1, Product[] var2, IO var3, Properties var4, CommandFactory var5);

    public final Command[] createSymbolicLinkCommands(Product[] productArray, String string, InstallOption installOption, CommandFactory commandFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        List<Product> list = Arrays.asList(productArray);
        if (ProductConditions.MATLAB.isSatisfied(string, list)) {
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "matlab"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mex"));
        }
        if (ProductConditions.MATLAB_COMPILER.isSatisfied(string, list)) {
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mcc"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "mbuild"));
            arrayList.add(commandFactory.createSymbolicLinkCommand(installOption, "deploytool"));
        }
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final boolean alwaysUseDefaultInstallFolderModel(String string, Product[] productArray) {
        List<Product> list = Arrays.asList(productArray);
        return ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, list) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, list);
    }

    @Override
    protected final String getLicenseAgreementPath() {
        return InstallCoreCommonResourceKeys.MATLAB_LICENSE_AGREEMENT.getString(new Object[0]);
    }

    private void addMATLABDistributedComputingEnginePreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createNamedService("mdced"), serviceFactory.createNamedService("mpich2_smpd")}), new Condition[]{ProductConditions.MATLAB_DISTRIBUTED_COMPUTING_ENGINE, ArchConditions.WIN64});
    }

    private void addMATLABCompiler(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, String string2, String string3, List<String> list) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(string2, MATLAB_EXE, this.isPathTooLong), ProductConditions.MATLAB_COMPILER);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsWithPathsCommand(string3, list, new String[]{"mwcomutil.dll", "mwcommgr.dll"}), ProductConditions.MATLAB_COMPILER);
    }

    private void addMATLAB(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, List<String> list) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRegisterDllsWithPathsCommand(AbstractMatlabInstallCommonConfiguration.buildPath("toolbox", "matlab", "winfun", string), list, new String[0]), ProductConditions.MATLAB);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(AbstractMatlabInstallCommonConfiguration.buildPath(PATH_TO_EXE), MATLAB_EXE, this.isPathTooLong), ProductConditions.MATLAB);
        String string2 = PATH_TO_EXE + File.separator + string;
        String string3 = InstutilResourceKeys.MATLABVERSION.getString(new Object[0]);
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createOLEAutomationCommand("mlautoregister.dll", string2, string3), ProductConditions.MATLAB);
    }

    private void addPolyspace(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createInsertPathIntoSystemPathCommand(AbstractMatlabInstallCommonConfiguration.buildPath("polyspace", PATH_TO_EXE), POLYSPACE_EXE, this.isPathTooLong), ProductConditions.POLYSPACE_BUG_FINDER);
    }

    private void addLicenseManagerPreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createStopServicesCommand(new Service[]{serviceFactory.createLicenseManagerService()}), new Condition[]{ProductConditions.LICENSE_MANAGER, ArchConditions.WIN64});
    }

    private void addCompilerSDK(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string2 = AbstractMatlabInstallCommonConfiguration.buildPath("toolbox", "dotnetbuilder", PATH_TO_EXE, string, "v4.0");
        arrayList.add(commandFactory.createInstallAssemblyFilesCommand(string2, new String[]{"MWArray.dll"}));
        arrayList.add(commandFactory.createRegisterAssemblyFolderCommand("DotNetBuilder", string2));
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createAssemblyFrameworkCommand(InstallResourceKeys.DOT_NET_BUILDER_ERROR_MESSAGE.getString(new Object[0]), (CommandErrorHandler)new DisplayCommandErrorHandler(), arrayList.toArray(new Command[arrayList.size()])), ProductConditions.MATLAB_COMPILER_SDK);
    }

    private void addDistributedComputingToolboxPreInstall(String string, Collection<Product> collection, Collection<Command> collection2, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection, collection2, commandFactory.createRemoveServicesCommand(new Service[]{serviceFactory.createNamedService("mpich2_smpd"), serviceFactory.createNamedService("mdced")}), ProductConditions.DISTRIBUTED_COMPUTING_TOOLBOX);
    }

    private String getStartMenuFolder() {
        return "MATLAB " + this.getReleaseAndVersionString();
    }

    private String getStartMenuFolderForPolyspace() {
        return "Polyspace " + this.getReleaseAndVersionString();
    }

    protected abstract String getReleaseAndVersionString();

    public final boolean requiresLicenseAgreement() {
        return true;
    }

    @Override
    public final String getApplicationName(String string, Collection<? extends Product> collection) {
        if (ProductConditions.MATLAB_PRODUCTION_SERVER.isSatisfied(string, collection)) {
            return MPS_APPLICATION_NAME;
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER.isSatisfied(string, collection) || ProductConditions.POLYSPACE_CODE_PROVER.isSatisfied(string, collection)) {
            return BFD_APPLICATION_NAME;
        }
        if (ProductConditions.POLYSPACE_BUG_FINDER_SERVER.isSatisfied(string, collection) || ProductConditions.POLYSPACE_CODE_PROVER_SERVER.isSatisfied(string, collection)) {
            return BFS_APPLICATION_NAME;
        }
        return MATLAB_APPLICATION_NAME;
    }

    @Override
    protected final void addAdditionalRegisterApplicationCommands(String string, CommandFactory commandFactory, Collection<Command> collection, Collection<Product> collection2) {
        this.addIfOnWindowsAndAllConditionsSatisfied(string, collection2, collection, commandFactory.createRegisterApplicationCommand(new RegisterAppPath(){

            public String getSubKey(String string) {
                return AbstractMatlabInstallCommonConfiguration.getExeKey(AbstractMatlabInstallCommonConfiguration.getFullPathToExe(new File(string)));
            }

            public String getName() {
                return "";
            }

            public String getKeyVal(String string) {
                return AbstractMatlabInstallCommonConfiguration.getFullPathToExe(new File(string)).getAbsolutePath();
            }
        }), ProductConditions.MATLAB);
    }

    public final String[] getSetupNotes(File file, InstallOption[] installOptionArray, HyperlinkProvider hyperlinkProvider, String string, Installer installer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AvailableProduct[] availableProductArray = installer.getSelectedAvailableProducts();
        this.addWin32NotSupportedNote(arrayList, string, availableProductArray);
        this.addCustomNotes(arrayList, installer, file);
        this.addLicenseManagerNote(file, string, availableProductArray, installOptionArray, arrayList);
        AbstractMatlabInstallCommonConfiguration.addCompilerRequiredNote(availableProductArray, arrayList, string);
        this.addSimulinkNote(availableProductArray, arrayList, string);
        AbstractMatlabInstallCommonConfiguration.addCompilerRecommendedNote(availableProductArray, arrayList, string);
        AbstractMatlabInstallCommonConfiguration.addMDCSNote(availableProductArray, arrayList, hyperlinkProvider);
        AbstractMatlabInstallCommonConfiguration.addMPSNote(availableProductArray, file, arrayList, string);
        AbstractMatlabInstallCommonConfiguration.addMatlabCompilerNotes(availableProductArray, arrayList, string);
        AbstractMatlabInstallCommonConfiguration.addMatlabCompilerSDKNotes(availableProductArray, arrayList, string);
        this.addTopLabel(arrayList);
        this.addTopLevelAdditionalNotes(installer, arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void addWin32NotSupportedNote(Collection<String> collection, String string, AvailableProduct[] availableProductArray) {
        if (ArchConditions.WIN32.isSatisfied(string, Arrays.asList(availableProductArray))) {
            AbstractMatlabInstallCommonConfiguration.addNote(collection, InstallCoreCommonResourceKeys.WIN32_NOT_SUPPORTED.getString(new Object[0]), RELEASE_STRING);
        }
    }

    protected void addCustomNotes(Collection<String> collection, Installer installer, File file) {
    }

    private void addLicenseManagerNote(File file, String string, AvailableProduct[] availableProductArray, InstallOption[] installOptionArray, Collection<String> collection) {
        List<AvailableProduct> list = Arrays.asList(availableProductArray);
        if (AbstractMatlabInstallCommonConfiguration.containsProduct(availableProductArray, 0)) {
            String string2 = this.getApplicationName(string, list);
            if (AbstractMatlabInstallCommonConfiguration.licenseManagerServiceSelected(installOptionArray)) {
                AbstractMatlabInstallCommonConfiguration.addNote(collection, InstallCoreCommonResourceKeys.SETUP_LMSERVICE_ARCH.getString(new Object[0]), string2, file.getAbsolutePath());
            } else {
                AbstractMatlabInstallCommonConfiguration.addNote(collection, InstallCoreCommonResourceKeys.SETUP_LMFILES_ARCH.getString(new Object[0]), string2, file.getAbsolutePath());
            }
        }
    }

    private void addSimulinkNote(AvailableProduct[] availableProductArray, Collection<String> collection, String string) {
        if (!ArchConditions.WIN64.isSatisfied(string, Arrays.asList(availableProductArray)) && AbstractMatlabInstallCommonConfiguration.containsProduct(availableProductArray, 2)) {
            for (String string2 : this.getSimulinkNotes(collection.size() + 1, RELEASE_STRING, AbstractMatlabInstallCommonConfiguration.getCompilerLink())) {
                AbstractMatlabInstallCommonConfiguration.addNote(collection, string2, new String[0]);
            }
        }
    }

    protected void addTopLabel(Collection<String> collection) {
        if (!collection.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(InstallCoreCommonResourceKeys.SETUP_LABEL_TOP.getString(new Object[0]));
            arrayList.addAll(collection);
            collection.clear();
            collection.addAll(arrayList);
        }
    }

    protected String[] getSimulinkNotes(int n, String string, String string2) {
        return new String[]{InstallCoreCommonResourceKeys.SETUP_SIMULINK_COMPILER.getString(n, string, string2)};
    }
}

