/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow.mcrworkflow;

import com.google.inject.Inject;
import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.workflow.mcrworkflow.BuildInstallerWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.DefaultOfflineWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.InitialWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.InstallationWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.MCRInstallWorkflowFactory;
import com.mathworks.installagent.workflow.mcrworkflow.PostInstallationWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.TypicalWorkflow;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import java.io.File;
import java.util.Properties;

public final class MCRInstallWorkflowFactoryImpl
implements MCRInstallWorkflowFactory {
    private final InstallModelFactory modelFactory;
    private final InstallCommandStepFactory commandStepFactory;
    private final ValidatedFik validatedFik;
    private final InstallWizardProperties initialActivationProperties;
    private final Properties installerProperties;
    private final Platform platform;
    private final Registry registry;
    private final String rootDir;

    @Inject
    MCRInstallWorkflowFactoryImpl(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, Properties properties, ValidatedFik validatedFik, Platform platform, Registry registry, SourcePathProvider sourcePathProvider) {
        this.modelFactory = installModelFactory;
        this.commandStepFactory = installCommandStepFactory;
        this.platform = platform;
        this.registry = registry;
        this.installerProperties = new Properties(properties);
        this.initialActivationProperties = this.modelFactory.createProperties();
        String string = properties.getProperty(PropertyKey.LWS.get());
        this.initialActivationProperties.setLWS(string);
        this.initialActivationProperties.setAWS(properties.getProperty(PropertyKey.AWS.get()));
        this.initialActivationProperties.setPropertiesFile(properties.getProperty(PropertyKey.ACTIVATION_PROPERTIES_FILE.get()));
        this.rootDir = sourcePathProvider.getSourcePath();
        this.validatedFik = validatedFik;
    }

    @Override
    public final Workflow createInitialWorkflow(File file) {
        return new InitialWorkflow(this.modelFactory, this.commandStepFactory, this, file, this.rootDir, this.installerProperties, this.initialActivationProperties.getProperties());
    }

    @Override
    public Workflow createOfflineWorkflow(Properties properties) {
        return new DefaultOfflineWorkflow(this.modelFactory, this.commandStepFactory, this, properties, (Model<ValidatedFik>)new ModelImpl((Object)this.validatedFik));
    }

    @Override
    public final Workflow createTypicalWorkflow(Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext) {
        return new TypicalWorkflow(this.modelFactory, this.commandStepFactory, this, installer, properties, validatedFik, installWizardContext, this.platform, this.registry);
    }

    @Override
    public final Workflow createBuildInstallerWorkflow(Properties properties, Model<ValidatedFik> model, InstallWizardContext installWizardContext) {
        return new BuildInstallerWorkflow(this.modelFactory, this.commandStepFactory, this, properties, model, installWizardContext);
    }

    @Override
    public final Workflow createInstallationWorkflow(Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Model<Boolean> model) {
        return new InstallationWorkflow(this.modelFactory, this.commandStepFactory, this, installer, file, installWizardContext, properties, validatedFik, installOptionArray);
    }

    @Override
    public Workflow createPostInstallationWorkflow(Properties properties, File file, Model<File> model, InstallWizardContext installWizardContext, ValidatedFik validatedFik, Installer installer, InstallOption[] installOptionArray, Model<Boolean> model2) {
        return new PostInstallationWorkflow(this.modelFactory, this.commandStepFactory, properties, file, model, installWizardContext, installer, installOptionArray, validatedFik);
    }
}

