/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow.mcrworkflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.installagent.workflow.mcrworkflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.mcrworkflow.MCRInstallWorkflowFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class InstallationWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final String confText;
    private final BackgroundTask installTask;
    private final Installer install;
    private final InstallWizardContext installWizardContext;
    private final ValidatedFik fik;
    private final InstallOption[] installOptions;
    private File installationFolder;
    private File downloadFolder;

    InstallationWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, MCRInstallWorkflowFactory mCRInstallWorkflowFactory, Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray) {
        super(installModelFactory, installCommandStepFactory, mCRInstallWorkflowFactory, properties);
        this.install = installer;
        this.installWizardContext = installWizardContext;
        this.fik = validatedFik;
        this.installOptions = (InstallOption[])installOptionArray.clone();
        this.installationFolder = file;
        this.downloadFolder = new File(file, "archives");
        this.confText = installWizardContext.buildMCRConfirmationText(file, installer);
        this.installTask = installModelFactory.createInstallTask(installer, file, this.downloadFolder);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.setInstallOptionsForPolyspaceStep(this.installOptions));
        this.addStep(installCommandStepFactory.createApplyInstallationOptionSelection(this.install, this.installOptions));
        this.addStep(panelStepBuilder.buildConfirmationStep(this.confText));
        this.addStep(installCommandStepFactory.createLoadFileListDataStep(this.installationFolder));
        this.addStep(installCommandStepFactory.createRunTaskStep(panelStepBuilder.buildStatusStep(this.installTask, false), this.installTask));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return "";
    }

    @Override
    protected Workflow createNewBranch(MCRInstallWorkflowFactory mCRInstallWorkflowFactory, Properties properties) {
        return mCRInstallWorkflowFactory.createPostInstallationWorkflow(properties, this.installationFolder, (Model<File>)new ModelImpl((Object)this.downloadFolder), this.installWizardContext, this.fik, this.install, this.installOptions, (Model<Boolean>)new ModelImpl((Object)false));
    }
}

