/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.SoftwareManager;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installagent.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;

final class ValidateInstallerWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<Installer> installerModel;
    private final InstallWizardContext installwizardContext;
    private final Model<ProductSetStatus> productSetStatusModel;
    private final UserAppInstallationProperties userAppInstallationProperties;
    private final InstallOption[] installOptions;
    private final Model<Boolean> atLeastOneMCRInstalled;
    private final Model<String> confirmationTextModel;
    private final DefaultedModel<String> mcrFolderModel;
    private final boolean skipBuildingInstaller;
    private final Model<UpdateStatus> updateStatusModel;
    private final FileSystem mcrFileSystem;
    private Model<Boolean> needUpdateModel;
    private final Model<Path> downloadFolderModel;

    protected ValidateInstallerWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties, Model<Installer> model, DefaultedModel<String> defaultedModel, InstallOption[] installOptionArray, InstallWizardContext installWizardContext, UserAppInstallationProperties userAppInstallationProperties, Model<ProductSetStatus> model2, boolean bl, Model<UpdateStatus> model3) {
        super(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, installAgentWorkflowFactory, properties);
        this.installerModel = model;
        this.installwizardContext = installWizardContext;
        this.productSetStatusModel = model2;
        this.userAppInstallationProperties = userAppInstallationProperties;
        this.installOptions = installOptionArray;
        this.mcrFolderModel = defaultedModel;
        this.skipBuildingInstaller = bl;
        this.updateStatusModel = model3;
        this.atLeastOneMCRInstalled = new ModelImpl((Object)false);
        this.needUpdateModel = new ModelImpl((Object)true);
        this.confirmationTextModel = new ModelImpl();
        this.mcrFileSystem = installModelFactory.createFileSystem((SoftwareManager)model.get(), defaultedModel);
        this.downloadFolderModel = new ModelImpl();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return !ValidateInstallerWorkflow.this.skipBuildingInstaller;
            }
        }, new Step[]{installCommandStepFactory.createCheckIfNoProductsStep(this.installerModel)});
        this.addStep(installCommandStepFactory.createCheckIfOverwriteImpossibleStep(this.mcrFolderModel, this.installerModel));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.mcrFileSystem));
        this.addStep(this.installagentCmdStepFactory.createGetNeedToUpdateModelStep(this.updateStatusModel, this.productSetStatusModel, this.needUpdateModel));
        this.addStep(this.installagentCmdStepFactory.createMCRProductSelectionAndGetConfirmationTextStep((Installer)this.installerModel.get(), this.mcrFolderModel, this.installwizardContext, this.productSetStatusModel, this.userAppInstallationProperties.getRequiredMCRProductIdentifiers(), this.userAppInstallationProperties.getApplicationName(), (Model<File>)this.userAppInstallationProperties.getUserAppInstallLocationModel(), this.mcrFileSystem, this.atLeastOneMCRInstalled, this.confirmationTextModel, this.skipBuildingInstaller, this.updateStatusModel, this.needUpdateModel));
        this.addStep(this.installagentCmdStepFactory.createDownloadFolderStep(this.mcrFolderModel, this.downloadFolderModel));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.mcrFolderModel.get() + this.installerModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties) {
        return installAgentWorkflowFactory.createInstallationWorkflow((Installer)this.installerModel.get(), (String)this.mcrFolderModel.get(), this.downloadFolderModel, this.installOptions, this.confirmationTextModel, this.atLeastOneMCRInstalled);
    }
}

