/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installagent.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class UserAppFolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private static final Product[] EMPTY_PRODUCTS = new Product[0];
    private final DefaultedModel<String> userAppFolderModel;
    private final DefaultedModel<String> userAppDisplayedFolderModel;
    private final FileSystem userAppFileSystem;
    private final Model<UpdateStatus> updateStatusModel;
    private InstallOptionModel desktopShortcutOption;
    private final Model<Installer> installerModel;
    private final UserAppInstallationProperties userAppInstallationProperties;
    private final InstallOption[] installOptionsArray;
    private final DefaultedModel<String> mcrFolderModel;
    private final Model<ProductSetStatus> productSetStatusModel;
    private String installerRoot;
    private final Model<ValidatedFik> fikModel;
    private final Model<Boolean> shouldShowErrorModel;
    private Model<Boolean> needUpdateModel;

    UserAppFolderSelectionWorkflow(String string, Model<ValidatedFik> model, Model<Installer> model2, InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, InstallAgentWorkflowFactory installAgentWorkflowFactory, UserAppInstallationProperties userAppInstallationProperties, Properties properties) {
        super(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, installAgentWorkflowFactory, properties);
        this.installerRoot = string;
        this.fikModel = model;
        this.installerModel = model2;
        this.userAppInstallationProperties = userAppInstallationProperties;
        block4: for (InstallOption installOption : this.installOptionsArray = ((Installer)model2.get()).getInstallOptionsForCurrentProductSelection(new Product[0])) {
            switch (installOption.getType()) {
                case DESKTOP_SHORTCUT: {
                    this.desktopShortcutOption = installModelFactory.createDesktopOptionModel(installOption);
                    continue block4;
                }
                case START_MENU_SHORTCUT: {
                    InstallOptionModel installOptionModel = installModelFactory.createStartMenuOptionModel(installOption);
                    installOptionModel.setSelected(true);
                }
            }
        }
        this.userAppFolderModel = installModelFactory.createUserAppFolderModel(userAppInstallationProperties.getUserAppInstallLocationModel());
        this.userAppDisplayedFolderModel = installModelFactory.createDisplayedFolderModel(this.userAppFolderModel, EMPTY_PRODUCTS);
        this.userAppFileSystem = installModelFactory.createUserAppFileSystem(Long.valueOf(userAppInstallationProperties.getUserAppUncompressedSize()), this.userAppFolderModel);
        this.mcrFolderModel = installModelFactory.createInstallFolderModel((Product[])((Installer)model2.get()).getAvailableProducts());
        this.productSetStatusModel = new ModelImpl((Object)ProductSetStatus.SAME_LEVEL_NO_CHANGE);
        this.updateStatusModel = new ModelImpl();
        this.needUpdateModel = new ModelImpl((Object)true);
        this.shouldShowErrorModel = new ModelImpl((Object)false);
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildUserAppFolderSelectionStep(this.userAppDisplayedFolderModel, this.userAppFileSystem, this.desktopShortcutOption, false));
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.userAppFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.userAppDisplayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.userAppFolderModel));
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.userAppFolderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.userAppFolderModel));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.userAppFileSystem));
        this.addStep(this.installagentCmdStepFactory.createCheckUpdateStatusStep(this.installerRoot, this.mcrFolderModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createCheckProductSetStatusStep(this.userAppInstallationProperties.getRequiredMCRProductIdentifiers(), this.mcrFolderModel, this.installerModel, this.productSetStatusModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createGetNeedToUpdateModelStep(this.updateStatusModel, this.productSetStatusModel, this.needUpdateModel));
        this.addStep(this.installagentCmdStepFactory.createCheckShouldShowErrorStep(this.updateStatusModel, this.productSetStatusModel, this.shouldShowErrorModel));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.mcrFolderModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties) {
        if (((Boolean)this.shouldShowErrorModel.get()).booleanValue()) {
            return installAgentWorkflowFactory.createUpdateErrorWorkflow();
        }
        return installAgentWorkflowFactory.createMCRFolderSelectionWorkflow(this.installerRoot, this.fikModel, this.installerModel, this.userAppFolderModel, properties, this.installOptionsArray, this.updateStatusModel, this.productSetStatusModel, this.needUpdateModel);
    }
}

