/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installagent.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.instutil.Registry;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;
import javax.swing.ImageIcon;

final class MCRFolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<Installer> installerModel;
    private final Model<Boolean> isDWSCallRequiredModel;
    private final DefaultedModel<String> userAppFolderModel;
    private final UserAppInstallationProperties userAppInstallationProperties;
    private final InstallOption[] installOptions;
    private final DefaultedModel<String> mcrFolderModel;
    private final DefaultedModel<String> mcrDisplayedFolderModel;
    private final ImageIcon mcrImageIcon;
    private final InstallWizardContext installwizardContext;
    private final Model<Boolean> needUpdateModel;
    private String installerRoot;
    private final Model<ValidatedFik> fikModel;
    private final Model<Boolean> canChangeFolderModel;
    private final Model<ProductSetStatus> productSetStatusModel;
    private final Model<Boolean> skipBuildingInstallerModel;
    private final Model<UpdateStatus> updateStatusModel;
    private final Model<Boolean> shouldShowErrorModel;

    MCRFolderSelectionWorkflow(String string, Model<ValidatedFik> model, Model<Installer> model2, InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, InstallAgentWorkflowFactory installAgentWorkflowFactory, DefaultedModel<String> defaultedModel, UserAppInstallationProperties userAppInstallationProperties, Properties properties, Registry registry, ImageIcon imageIcon, InstallOption[] installOptionArray, Model<UpdateStatus> model3, Model<ProductSetStatus> model4, Model<Boolean> model5) {
        super(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, installAgentWorkflowFactory, properties);
        this.installerRoot = string;
        this.fikModel = model;
        this.installerModel = model2;
        this.userAppFolderModel = defaultedModel;
        this.userAppInstallationProperties = userAppInstallationProperties;
        this.productSetStatusModel = model4;
        this.installOptions = installOptionArray;
        this.mcrFolderModel = installModelFactory.createInstallFolderModel((Product[])((Installer)model2.get()).getAvailableProducts());
        this.mcrDisplayedFolderModel = installModelFactory.createDisplayedFolderModel(this.mcrFolderModel, (Product[])((Installer)model2.get()).getAvailableProducts());
        this.installwizardContext = installModelFactory.createContext();
        this.canChangeFolderModel = installModelFactory.createMCRInstallStatusModel(this.installwizardContext, registry, (Installer)model2.get());
        this.isDWSCallRequiredModel = new ModelImpl((Object)true);
        this.mcrImageIcon = imageIcon;
        this.updateStatusModel = model3;
        this.skipBuildingInstallerModel = new ModelImpl((Object)false);
        this.shouldShowErrorModel = new ModelImpl((Object)false);
        this.needUpdateModel = model5;
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        if (((Boolean)this.canChangeFolderModel.get()).booleanValue()) {
            this.addStep(panelStepBuilder.createMCRAlreadyInstalledPanelStep(this.mcrImageIcon, this.mcrDisplayedFolderModel, this.needUpdateModel));
        } else {
            this.addStep(panelStepBuilder.createMCRFolderSelectionPanelStep(this.mcrDisplayedFolderModel, this.mcrImageIcon));
        }
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.mcrFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.mcrDisplayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.mcrFolderModel));
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.mcrFolderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.mcrFolderModel));
        this.addStep(this.installagentCmdStepFactory.createCheckUpdateStatusStep(this.installerRoot, this.mcrFolderModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createCheckProductSetStatusStep(this.userAppInstallationProperties.getRequiredMCRProductIdentifiers(), this.mcrFolderModel, this.installerModel, this.productSetStatusModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createCheckShouldShowErrorStep(this.updateStatusModel, this.productSetStatusModel, this.shouldShowErrorModel));
        this.addStep(this.installagentCmdStepFactory.createIsDWSCallRequiredStep(this.installerModel, this.productSetStatusModel, this.mcrFolderModel, this.isDWSCallRequiredModel, this.skipBuildingInstallerModel, this.updateStatusModel));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.userAppFolderModel.get() + (String)this.mcrFolderModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties) {
        if (((Boolean)this.shouldShowErrorModel.get()).booleanValue()) {
            return installAgentWorkflowFactory.createUpdateErrorWorkflow();
        }
        if (((Boolean)this.isDWSCallRequiredModel.get()).booleanValue()) {
            return installAgentWorkflowFactory.createDWSWorkflow(this.fikModel, this.installerModel, this.userAppInstallationProperties, this.mcrFolderModel, properties, this.installOptions, this.installwizardContext, this.productSetStatusModel, this.updateStatusModel);
        }
        return installAgentWorkflowFactory.createValidateInstallerSWorkflow(this.installerModel, this.installwizardContext, this.productSetStatusModel, this.userAppInstallationProperties, this.installOptions, this.mcrFolderModel, properties, (Boolean)this.skipBuildingInstallerModel.get(), this.updateStatusModel);
    }
}

