/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.workflow.AbstractSimpleInstallWorkflow;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.io.File;
import java.nio.file.Path;

final class InstallationWorkflow
extends AbstractSimpleInstallWorkflow {
    private final Model<String> confirmationTextModel;
    private final BackgroundTask installTask;
    private final InstallAgentCommandStepFactory installAgentCommandStepFactory;
    private final Installer installer;
    private final InstallOption[] installOptions;
    private final File installFolderFile;
    private final Model<Path> downloadFolderModel;
    private final String notesText;
    private final Model<Boolean> agreeToLicense;
    private final Model<Boolean> atLeastOneMCRInstalled;
    private final Model<File> userInstallFolder;

    InstallationWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, Installer installer, String string, Model<Path> model, InstallOption[] installOptionArray, Model<String> model2, UserAppInstallationProperties userAppInstallationProperties, Model<Boolean> model3) {
        super(installCommandStepFactory);
        this.installAgentCommandStepFactory = installAgentCommandStepFactory;
        this.installer = installer;
        this.confirmationTextModel = model2;
        this.atLeastOneMCRInstalled = model3;
        this.installOptions = (InstallOption[])installOptionArray.clone();
        this.installFolderFile = new File(string);
        this.downloadFolderModel = model;
        this.installTask = installModelFactory.createInstallTask(installer, this.installFolderFile, ((Path)model.get()).toFile());
        this.notesText = userAppInstallationProperties.getInstallNotesText();
        this.agreeToLicense = installModelFactory.createAgreeToLicenseSwitch();
        this.userInstallFolder = userAppInstallationProperties.getUserAppInstallLocationModel();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return (Boolean)InstallationWorkflow.this.atLeastOneMCRInstalled.get() == false;
            }
        }, new Step[]{installCommandStepFactory.createLicenseAgreementStep(panelStepBuilder, this.agreeToLicense)});
        this.addStep(installCommandStepFactory.createApplyInstallationOptionSelection(this.installer, this.installOptions));
        this.addStep(panelStepBuilder.buildConfirmationStep((String)this.confirmationTextModel.get(), false));
        this.addStep(installCommandStepFactory.createLoadFileListDataStep(this.installFolderFile));
        this.addStep(installCommandStepFactory.createRunTaskStep(panelStepBuilder.buildStatusStep(this.installTask, false, false), this.installTask));
        this.addStep(panelStepBuilder.buildInstallAgentFinalPanel(this.notesText, this.userInstallFolder));
        this.addStep(this.installAgentCommandStepFactory.createDeleteDWSArchivesStep(this.downloadFolderModel));
        this.addStep(installCommandStepFactory.createCloseUIStep());
    }
}

