/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.google.inject.Inject;
import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installagent.workflow.DWSWorkflow;
import com.mathworks.installagent.workflow.InitialWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installagent.workflow.InstallationWorkflow;
import com.mathworks.installagent.workflow.MCRFolderSelectionWorkflow;
import com.mathworks.installagent.workflow.UpdateErrorWorkflow;
import com.mathworks.installagent.workflow.UserAppFolderSelectionWorkflow;
import com.mathworks.installagent.workflow.ValidateInstallerWorkflow;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.instutil.Registry;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import javax.swing.ImageIcon;

public class InstallAgentWorkflowFactoryImpl
implements InstallAgentWorkflowFactory {
    private final InstallModelFactory modelFactory;
    private final InstallCommandStepFactory commandStepFactory;
    private final InstallWizardProperties initialProperties;
    private final Registry registry;
    private final ValidatedFik validatedFik;
    private final UserAppInstallationProperties userAppInstallationProperties;
    private final ImageIcon mcrImageIcon;
    private final InstallAgentCommandStepFactory installAgentCommandStepFactory;
    private final Properties installerProperties;

    @Inject
    public InstallAgentWorkflowFactoryImpl(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, Properties properties, Registry registry, ValidatedFik validatedFik, UserAppInstallationProperties userAppInstallationProperties, ImageIcon imageIcon) {
        this.userAppInstallationProperties = userAppInstallationProperties;
        this.modelFactory = installModelFactory;
        this.commandStepFactory = installCommandStepFactory;
        this.installAgentCommandStepFactory = installAgentCommandStepFactory;
        this.registry = registry;
        this.installerProperties = new Properties(properties);
        this.initialProperties = this.modelFactory.createProperties();
        String string = properties.getProperty(PropertyKey.LWS.get());
        this.initialProperties.setLWS(string);
        this.initialProperties.setAWS(properties.getProperty(PropertyKey.AWS.get()));
        this.initialProperties.setPropertiesFile(properties.getProperty(PropertyKey.ACTIVATION_PROPERTIES_FILE.get()));
        this.validatedFik = validatedFik;
        this.mcrImageIcon = imageIcon;
    }

    @Override
    public Workflow createInitialWorkflow(Model<Boolean> model, String string, File file) {
        return new InitialWorkflow(model, this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, this, string, file, this.installerProperties, this.initialProperties.getProperties(), this.userAppInstallationProperties.getUserIcons(), this.userAppInstallationProperties.getApplicationName(), this.userAppInstallationProperties.getWelcomePanelText(), this.validatedFik);
    }

    @Override
    public Workflow createUserAppFolderSelectionWorkflow(String string, Model<ValidatedFik> model, Model<Installer> model2, Properties properties) {
        return new UserAppFolderSelectionWorkflow(string, model, model2, this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, this, this.userAppInstallationProperties, properties);
    }

    @Override
    public Workflow createMCRFolderSelectionWorkflow(String string, Model<ValidatedFik> model, Model<Installer> model2, DefaultedModel<String> defaultedModel, Properties properties, InstallOption[] installOptionArray, Model<UpdateStatus> model3, Model<ProductSetStatus> model4, Model<Boolean> model5) {
        return new MCRFolderSelectionWorkflow(string, model, model2, this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, this, defaultedModel, this.userAppInstallationProperties, properties, this.registry, this.mcrImageIcon, installOptionArray, model3, model4, model5);
    }

    @Override
    public Workflow createDWSWorkflow(Model<ValidatedFik> model, Model<Installer> model2, UserAppInstallationProperties userAppInstallationProperties, DefaultedModel<String> defaultedModel, Properties properties, InstallOption[] installOptionArray, InstallWizardContext installWizardContext, Model<ProductSetStatus> model3, Model<UpdateStatus> model4) {
        return new DWSWorkflow(this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, this, properties, model, model2, defaultedModel, installOptionArray, installWizardContext, model3, userAppInstallationProperties, model4);
    }

    @Override
    public Workflow createValidateInstallerSWorkflow(Model<Installer> model, InstallWizardContext installWizardContext, Model<ProductSetStatus> model2, UserAppInstallationProperties userAppInstallationProperties, InstallOption[] installOptionArray, DefaultedModel<String> defaultedModel, Properties properties, boolean bl, Model<UpdateStatus> model3) {
        return new ValidateInstallerWorkflow(this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, this, properties, model, defaultedModel, installOptionArray, installWizardContext, userAppInstallationProperties, model2, bl, model3);
    }

    @Override
    public Workflow createInstallationWorkflow(Installer installer, String string, Model<Path> model, InstallOption[] installOptionArray, Model<String> model2, Model<Boolean> model3) {
        return new InstallationWorkflow(this.modelFactory, this.commandStepFactory, this.installAgentCommandStepFactory, installer, string, model, installOptionArray, model2, this.userAppInstallationProperties, model3);
    }

    @Override
    public Workflow createUpdateErrorWorkflow() {
        return new UpdateErrorWorkflow(this.commandStepFactory, this.userAppInstallationProperties.getApplicationName());
    }
}

