/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.InstallAgentResourceKeys;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installwizard.InstallWizardPropertyKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.command.WebServiceStatus;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

final class InitialWorkflow
extends AbstractBranchingInstallWorkflow<Boolean> {
    private static final String ARCHIVES = "archives";
    private final File libDir;
    private final List<File> archiveDirs;
    private final Model<Boolean> bundleLoadedModel;
    private final String installRoot;
    private final List<Image> userIcons;
    private final String applicationName;
    private final String welcomePanelText;
    private final Model<ValidatedFik> validatedFikModel;
    private final Model<Installer> installerModel;
    private final Model<WebServiceStatus> webServiceStatusModel;

    InitialWorkflow(Model<Boolean> model, InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, InstallAgentWorkflowFactory installAgentWorkflowFactory, String string, File file, Properties properties, Properties properties2, List<Image> list, String string2, String string3, ValidatedFik validatedFik) {
        super(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, installAgentWorkflowFactory, properties2);
        this.bundleLoadedModel = model;
        this.installRoot = string;
        this.userIcons = list;
        this.libDir = file;
        this.applicationName = string2;
        this.welcomePanelText = string3;
        this.installerModel = new ModelImpl();
        this.validatedFikModel = new ModelImpl((Object)validatedFik);
        this.webServiceStatusModel = new ModelImpl();
        String string4 = new File(string, ARCHIVES).getAbsolutePath();
        String string5 = properties.getProperty(InstallWizardPropertyKey.ARCHIVES.get(), string4);
        File file2 = new File(string5);
        this.archiveDirs = new ArrayList<File>();
        this.archiveDirs.add(file2);
        this.archiveDirs.add(new File(string));
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createValidStateCheck(((Boolean)this.bundleLoadedModel.get()).booleanValue(), InstallAgentResourceKeys.BUNDLE_ERROR.getString(new Object[0]), InstallAgentResourceKeys.BUNDLE_ERROR_TITLE.getString(new Object[0])));
        this.addStep(installCommandStepFactory.createSetFrameImagesStep(this.userIcons));
        this.addStep(installCommandStepFactory.createLoadNativeLibrariesStep(this.libDir.getAbsolutePath()));
        this.addStep(installCommandStepFactory.createStartReadingArchivesStep(this.archiveDirs.toArray(new File[this.archiveDirs.size()])));
        this.addStep(panelStepBuilder.buildInstallAgentWelcomeStep(this.installagentCmdStepFactory.createProxyConnectToServiceStep(this.webServiceStatusModel), this.applicationName, this.welcomePanelText));
        this.addStep(installCommandStepFactory.createCheckInstallerRequirementsStep());
        this.addStep(installCommandStepFactory.createFinishReadingArchivesStep());
        this.addStep(installCommandStepFactory.createBuildInstallerStep(this.validatedFikModel, this.installerModel));
    }

    @Override
    protected Boolean evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (Boolean)this.bundleLoadedModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties) {
        return installAgentWorkflowFactory.createUserAppFolderSelectionWorkflow(this.installRoot, this.validatedFikModel, this.installerModel, properties);
    }
}

