/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.workflow;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installagent.workflow.AbstractBranchingInstallWorkflow;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.command.WebServiceStatus;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class DWSWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<Installer> installerModel;
    private final InstallWizardContext installwizardContext;
    private final Model<ProductSetStatus> productSetStatusModel;
    private final UserAppInstallationProperties userAppInstallationProperties;
    private Model<UpdateStatus> updateStatusModel;
    private final Model<WebServiceStatus> webServiceStatusModel;
    private final Model<ValidatedFik> validatedFik;
    private final InstallOption[] installOptions;
    private final DefaultedModel<String> mcrFolderModel;

    protected DWSWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties, Model<ValidatedFik> model, Model<Installer> model2, DefaultedModel<String> defaultedModel, InstallOption[] installOptionArray, InstallWizardContext installWizardContext, Model<ProductSetStatus> model3, UserAppInstallationProperties userAppInstallationProperties, Model<UpdateStatus> model4) {
        super(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, installAgentWorkflowFactory, properties);
        this.installerModel = model2;
        this.installwizardContext = installWizardContext;
        this.productSetStatusModel = model3;
        this.userAppInstallationProperties = userAppInstallationProperties;
        this.updateStatusModel = model4;
        this.webServiceStatusModel = new ModelImpl();
        this.validatedFik = model;
        this.installOptions = installOptionArray;
        this.mcrFolderModel = defaultedModel;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(this.installagentCmdStepFactory.createGetRuntimeReleaseDataStep(this.webServiceStatusModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createGetRuntimeComponentsStep(this.webServiceStatusModel, this.updateStatusModel));
        this.addStep(this.installagentCmdStepFactory.createCheckIfOnlineAndWebServiceUpStep(this.webServiceStatusModel, this.installerModel));
        this.addStep(installCommandStepFactory.createBuildInstallerStep(this.validatedFik, this.installerModel));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.mcrFolderModel.get() + this.installerModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallAgentWorkflowFactory installAgentWorkflowFactory, Properties properties) {
        return installAgentWorkflowFactory.createValidateInstallerSWorkflow(this.installerModel, this.installwizardContext, this.productSetStatusModel, this.userAppInstallationProperties, this.installOptions, this.mcrFolderModel, properties, false, this.updateStatusModel);
    }
}

