/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.updates;

import com.mathworks.installagent.updates.InstallAgentReleaseInfoUtil;
import com.mathworks.release_info.ReleaseInfo;
import com.mathworks.release_info.ReleaseInfoUtils;
import com.mathworks.wizard.resources.WizardResourceKeys;

public class UpdateStatus {
    private static final String RELEASE_STRING = WizardResourceKeys.RELEASE.getString(new Object[0]);
    private static final String PRE_RELEASE = "Prerelease";
    private static final String UPDATE_LEVEL_0 = "0";
    private ReleaseInfo currentReleaseInfo;
    private ReleaseInfo targetReleaseInfo;
    private Status currentStatus;

    public UpdateStatus(ReleaseInfo releaseInfo, ReleaseInfo releaseInfo2) {
        this.currentReleaseInfo = releaseInfo;
        this.targetReleaseInfo = releaseInfo2;
        this.currentStatus = this.determineCurrentStatus();
    }

    public String getCurrentReleaseFamily() {
        String string = RELEASE_STRING;
        if (this.currentReleaseInfo != null) {
            string = this.currentReleaseInfo.getReleaseFamily();
        }
        return string;
    }

    public String getCurrentReleaseStatus() {
        String string = PRE_RELEASE;
        if (this.currentReleaseInfo != null) {
            ReleaseInfo.Status status = this.currentReleaseInfo.getStatus();
            string = this.convertReleaseStatus(status);
        }
        return string;
    }

    public String getCurrentUpdateLevel() {
        String string = UPDATE_LEVEL_0;
        if (this.currentReleaseInfo != null) {
            string = Integer.toString(this.currentReleaseInfo.getUpdateLevel());
        }
        return string;
    }

    public String getTargetReleaseFamily() {
        String string = RELEASE_STRING;
        if (this.targetReleaseInfo != null) {
            string = this.targetReleaseInfo.getReleaseFamily();
        }
        return string;
    }

    public String getTargetReleaseStatus() {
        String string = PRE_RELEASE;
        if (this.targetReleaseInfo != null) {
            ReleaseInfo.Status status = this.targetReleaseInfo.getStatus();
            string = this.convertReleaseStatus(status);
        }
        return string;
    }

    public String getTargetUpdateLevel() {
        String string = UPDATE_LEVEL_0;
        if (this.targetReleaseInfo != null) {
            string = Integer.toString(this.targetReleaseInfo.getUpdateLevel());
        }
        return string;
    }

    public Status getStatus() {
        return this.currentStatus;
    }

    private String convertReleaseStatus(ReleaseInfo.Status status) {
        return status.name().substring(0, 1) + status.name().substring(1).toLowerCase();
    }

    private Status determineCurrentStatus() {
        Status status = this.currentReleaseInfo == null ? Status.FRESH_INSTALL : (ReleaseInfoUtils.sameRelease((ReleaseInfo)this.targetReleaseInfo, (ReleaseInfo)this.currentReleaseInfo) ? (InstallAgentReleaseInfoUtil.isReleaseDescriptionDifferent(this.targetReleaseInfo, this.currentReleaseInfo) ? Status.UP_GRADE : (ReleaseInfoUtils.sameUpdateLevel((ReleaseInfo)this.targetReleaseInfo, (ReleaseInfo)this.currentReleaseInfo) ? Status.SAME_LEVEL : (this.targetReleaseInfo.getUpdateLevel() > this.currentReleaseInfo.getUpdateLevel() ? Status.UP_GRADE : Status.DOWN_GRADE))) : Status.UP_GRADE);
        return status;
    }

    public static enum Status {
        FRESH_INSTALL,
        SAME_LEVEL,
        UP_GRADE,
        DOWN_GRADE;

    }
}

