/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.updates;

import com.mathworks.release_info.ReleaseInfo;
import com.mathworks.release_info.ReleaseInfoUtils;
import com.mathworks.release_info.VersionInfoXmlBasedReleaseInfo;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class InstallAgentReleaseInfoUtil {
    private static final String UNDER_SCORE = "_";
    private static final String EMPTY_STRING = "";

    public static ReleaseInfo getReleaseInfoInMCRInstaller(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist: " + file.toString());
        }
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry(ReleaseInfoUtils.VERSION_INFO_FILE_NAME);
        if (zipEntry == null) {
            throw new IOException("Corrupted file: " + file.toString());
        }
        return new VersionInfoXmlBasedReleaseInfo(zipFile.getInputStream(zipEntry));
    }

    public static String convertReleaseStatus(ReleaseInfo.Status status) {
        return status.name().substring(0, 1) + status.name().substring(1).toLowerCase();
    }

    public static boolean isTargetReleaseHigher(ReleaseInfo releaseInfo, ReleaseInfo releaseInfo2) {
        ReleaseInfo.Status status = releaseInfo2.getStatus();
        ReleaseInfo.Status status2 = releaseInfo.getStatus();
        boolean bl = status2 == ReleaseInfo.Status.RELEASE ? status == ReleaseInfo.Status.PRERELEASE || status == ReleaseInfo.Status.DEVELOPMENT : (status2 == ReleaseInfo.Status.PRERELEASE ? status == ReleaseInfo.Status.DEVELOPMENT : false);
        return bl;
    }

    public static boolean isReleaseDescriptionDifferent(ReleaseInfo releaseInfo, ReleaseInfo releaseInfo2) {
        boolean bl = false;
        if (releaseInfo.getStatus() != releaseInfo2.getStatus()) {
            bl = true;
        }
        return bl;
    }
}

