/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstalledProduct;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install_impl.InstalledProductFactory;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class MCRProductSelectionAndGetConfirmationTextStep
extends AbstractCommandStep {
    private static final String SEP = System.getProperty("line.separator");
    private final UpdateStatus.Status status;
    private Model<File> userAppInstallLocationModel;
    private Installer installer;
    private Model<Boolean> atLeastOneMCRInstalled;
    private DefaultedModel<String> installFolderModel;
    private List<Integer> requiredMCRProductIdentifiers;
    private FileSystem mcrFileSystem;
    private InstallWizardContext context;
    private String applicationName;
    private Model<String> confirmationTextModel;
    private boolean skipBuildingInstaller;
    private Model<UpdateStatus> updateStatusModel;
    private Model<Boolean> needUpdateModel;

    MCRProductSelectionAndGetConfirmationTextStep(Installer installer, DefaultedModel<String> defaultedModel, InstallWizardContext installWizardContext, List<Integer> list, String string, Model<File> model, FileSystem fileSystem, Model<Boolean> model2, Model<String> model3, boolean bl, Model<UpdateStatus> model4, Model<Boolean> model5) {
        this.installer = installer;
        this.atLeastOneMCRInstalled = model2;
        this.installFolderModel = defaultedModel;
        this.mcrFileSystem = fileSystem;
        this.requiredMCRProductIdentifiers = list;
        this.userAppInstallLocationModel = model;
        this.context = installWizardContext;
        this.applicationName = string;
        this.confirmationTextModel = model3;
        this.skipBuildingInstaller = bl;
        this.updateStatusModel = model4;
        this.needUpdateModel = model5;
        this.status = ((UpdateStatus)model4.get()).getStatus();
    }

    protected boolean forwardVisitStep() {
        File file = new File((String)this.installFolderModel.get());
        if (this.status == UpdateStatus.Status.UP_GRADE || this.status == UpdateStatus.Status.DOWN_GRADE) {
            this.atLeastOneMCRInstalled.set((Object)true);
        } else if (this.skipBuildingInstaller) {
            this.atLeastOneMCRInstalled.set((Object)true);
        } else {
            this.atLeastOneMCRInstalled.set((Object)(this.installer.getSelectedProductsAlreadyInstalled(file).length != 0 ? 1 : 0));
        }
        this.deselectNotRequiredProducts((SoftwareManager)this.installer, this.requiredMCRProductIdentifiers);
        if (this.status == UpdateStatus.Status.UP_GRADE || this.status == UpdateStatus.Status.DOWN_GRADE) {
            this.selectInstalledProduct();
        }
        this.setDependentAndInstalledProductStatus(this.installer, file, this.updateStatusModel);
        Long l = this.mcrFileSystem.getMegabytesToDownload();
        String string = "";
        if (l != 0L) {
            string = MessageFormat.format(WizardResourceKeys.MCR_DOWNLOAD_SIZE_LABEL.getString(new Object[0]), l);
        }
        String string2 = this.context.buildInstallAgentConfirmationText(file.getAbsolutePath(), ((File)this.userAppInstallLocationModel.get()).getAbsolutePath(), this.applicationName, this.atLeastOneMCRInstalled, this.needUpdateModel);
        this.confirmationTextModel.set((Object)(string2 + SEP + SEP + string));
        return true;
    }

    private void selectInstalledProduct() {
        Collection collection = InstalledProductFactory.getInstalledProducts((String)((String)this.installFolderModel.get()));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (InstalledProduct installedProduct : collection) {
            arrayList.add(installedProduct.getNumber());
        }
        for (AvailableProduct availableProduct : this.installer.getAvailableProducts()) {
            if (!arrayList.contains(availableProduct.getProductNumber())) continue;
            availableProduct.setSelected(true);
        }
    }

    private void deselectNotRequiredProducts(SoftwareManager softwareManager, List<Integer> list) {
        for (AvailableProduct availableProduct : softwareManager.getAvailableProducts()) {
            if (list.contains(availableProduct.getProductNumber())) continue;
            availableProduct.setSelected(false);
        }
    }

    private void setDependentAndInstalledProductStatus(Installer installer, File file, Model<UpdateStatus> model) {
        Product[] productArray = installer.getDependencies();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Product product : productArray) {
            arrayList.add(product.getProductNumber());
        }
        if (arrayList.size() > 0) {
            for (Product product : installer.getAvailableProducts()) {
                if (!arrayList.contains(product.getProductNumber())) continue;
                product.setSelected(true);
            }
        }
        if (this.status != UpdateStatus.Status.UP_GRADE) {
            for (Product product : installer.getSelectedProductsAlreadyInstalled(file)) {
                arrayList2.add(product.getProductNumber());
                product.setOverwrite(false);
                product.setSelected(false);
            }
        }
    }
}

