/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstalledProduct;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install_impl.InstalledProductFactory;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installagent.InstallAgentResourceKeys;
import com.mathworks.installagent.command.GenerateTempDownloadFolder;
import com.mathworks.installagent.command.GetRuntimeComponentsCallable;
import com.mathworks.installagent.command.GetRuntimeReleaseDataCallable;
import com.mathworks.installagent.command.InstallAgentCommandStep;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.command.MCRDWSRestClientProxy;
import com.mathworks.installagent.command.MCRProductSelectionAndGetConfirmationTextStep;
import com.mathworks.installagent.updates.ProductSetStatus;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.command.WebServiceStatus;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.release_info.ReleaseInfo;
import com.mathworks.release_info.ReleaseInfoUtils;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.command.ServiceTaskStep;
import com.mathworks.wizard.command.ServiceTaskStepForArchives;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

public final class InstallAgentCommandStepFactoryImpl
implements InstallAgentCommandStepFactory {
    private final MCRDWSRestClientProxy mcrdwsRestClientProxy;
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String archString;
    private final AppLogger logger;
    private final WorkerFactory workerFactory;
    private final WizardUI wizardUI;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final InstallerBuilder installerBuilder;
    private final IO io;

    public InstallAgentCommandStepFactoryImpl(String string, WizardUI wizardUI, InstallerBuilder installerBuilder, ExceptionHandler exceptionHandler, AppLogger appLogger, String string2, IO iO, WorkerFactory workerFactory, Downloader downloader, ProxyConfiguration proxyConfiguration, MCRDWSRestClientProxy mCRDWSRestClientProxy) {
        this.mcrdwsRestClientProxy = mCRDWSRestClientProxy;
        this.exceptionHandler = exceptionHandler;
        this.clientString = string2;
        this.archString = string;
        this.logger = appLogger;
        this.workerFactory = workerFactory;
        this.wizardUI = wizardUI;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.installerBuilder = installerBuilder;
        this.io = iO;
    }

    @Override
    public final Step createProxyConnectToServiceStep(Model<WebServiceStatus> model) {
        GetRuntimeReleaseDataCallable getRuntimeReleaseDataCallable = new GetRuntimeReleaseDataCallable(this.mcrdwsRestClientProxy, this.exceptionHandler, this.clientString, this.archString, model, WizardResourceKeys.PROXY_ERROR_TITLE.getString(new Object[0]), WizardResourceKeys.PROXY_ERROR_MESSAGE.getString(new Object[0]));
        return new ServiceTaskStepForArchives((Callable)getRuntimeReleaseDataCallable, this.workerFactory, this.wizardUI, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]), WizardResourceKeys.SERVICE_PROXY_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetRuntimeReleaseDataStep(Model<WebServiceStatus> model, Model<UpdateStatus> model2) {
        GetRuntimeReleaseDataCallable getRuntimeReleaseDataCallable = new GetRuntimeReleaseDataCallable(this.mcrdwsRestClientProxy, this.exceptionHandler, this.clientString, this.archString, model, model2);
        return new ServiceTaskStep((Callable)getRuntimeReleaseDataCallable, this.workerFactory, this.wizardUI, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]), ResourceKeys.SERVICE_DWS_CHECK_MESSAGE.getString(new Object[0]), this.logger);
    }

    @Override
    public final Step createGetRuntimeComponentsStep(Model<WebServiceStatus> model, Model<UpdateStatus> model2) {
        GetRuntimeComponentsCallable getRuntimeComponentsCallable = new GetRuntimeComponentsCallable(this.exceptionHandler, this.clientString, this.installerBuilder, model, this.downloader, this.proxyConfiguration, this.io, this.archString, this.mcrdwsRestClientProxy, model2);
        return new ServiceTaskStep((Callable)getRuntimeComponentsCallable, this.workerFactory, this.wizardUI, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]), ResourceKeys.SERVICE_PREPARING_INSTALLATION_MESSAGE.getString(new Object[0]), this.logger);
    }

    @Override
    public Step createCheckIfOnlineAndWebServiceUpStep(final Model<WebServiceStatus> model, final Model<Installer> model2) {
        return new InstallAgentCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((Installer)model2.get()).getAvailableProducts().length == 0 && !((WebServiceStatus)model.get()).isWebServiceUp()) {
                    InstallAgentCommandStepFactoryImpl.this.wizardUI.showErrorMessage(ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), InstallAgentResourceKeys.ERROR_CONNECTION_MESSAGE.getString(WizardResourceKeys.RELEASE.getString(new Object[0]), InstallAgentCommandStepFactoryImpl.this.archString));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Step createIsDWSCallRequiredStep(final Model<Installer> model, final Model<ProductSetStatus> model2, final DefaultedModel<String> defaultedModel, final Model<Boolean> model3, final Model<Boolean> model4, final Model<UpdateStatus> model5) {
        return new InstallAgentCommandStep(){

            @Override
            boolean forwardVisitStep() {
                boolean bl = ((Installer)model.get()).getAvailableProducts().length == 0;
                ProductSetStatus productSetStatus = (ProductSetStatus)((Object)model2.get());
                model3.set((Object)false);
                model4.set((Object)true);
                switch (((UpdateStatus)model5.get()).getStatus()) {
                    case UP_GRADE: {
                        if (productSetStatus == ProductSetStatus.ONLINE_SUB_SET || productSetStatus == ProductSetStatus.ONLINE_SAME_SET || productSetStatus == ProductSetStatus.ONLINE_SUPER_SET || productSetStatus == ProductSetStatus.ONLINE_MIS_MATCH) {
                            model3.set((Object)true);
                            model4.set((Object)false);
                            break;
                        }
                        model4.set((Object)false);
                        break;
                    }
                    case DOWN_GRADE: {
                        if (productSetStatus != ProductSetStatus.ONLINE_SUPER_SET && productSetStatus != ProductSetStatus.ONLINE_MIS_MATCH) break;
                        model3.set((Object)true);
                        model4.set((Object)false);
                        break;
                    }
                    default: {
                        model3.set((Object)(bl && (InstallAgentCommandStepFactoryImpl.this.checkIfNoMCRProductsInstalled((DefaultedModel<String>)defaultedModel) || productSetStatus == ProductSetStatus.SAME_LEVEL_ADDITIONAL) ? 1 : 0));
                        model4.set((Object)(bl && !InstallAgentCommandStepFactoryImpl.this.checkIfNoMCRProductsInstalled((DefaultedModel<String>)defaultedModel) && productSetStatus != ProductSetStatus.SAME_LEVEL_ADDITIONAL ? 1 : 0));
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckUpdateStatusStep(final String string, final DefaultedModel<String> defaultedModel, final Model<UpdateStatus> model) {
        return new InstallAgentCommandStep(){

            @Override
            boolean forwardVisitStep() {
                ReleaseInfo releaseInfo = null;
                ReleaseInfo releaseInfo2 = null;
                try {
                    releaseInfo2 = ReleaseInfoUtils.getReleaseInfo((String)((String)defaultedModel.get()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    releaseInfo = ReleaseInfoUtils.getReleaseInfo((String)string);
                }
                catch (IOException iOException) {
                    InstallAgentCommandStepFactoryImpl.this.logger.safeLogMsg(iOException.getMessage());
                }
                if (releaseInfo2 != null) {
                    InstallAgentCommandStepFactoryImpl.this.logger.safeLogMsg("Current update level: " + releaseInfo2.getUpdateLevel());
                }
                if (releaseInfo != null) {
                    InstallAgentCommandStepFactoryImpl.this.logger.safeLogMsg("Target update level: " + releaseInfo.getUpdateLevel());
                }
                UpdateStatus updateStatus = new UpdateStatus(releaseInfo2, releaseInfo);
                model.set((Object)updateStatus);
                return true;
            }
        };
    }

    @Override
    public Step createCheckProductSetStatusStep(final List<Integer> list, final DefaultedModel<String> defaultedModel, final Model<Installer> model, final Model<ProductSetStatus> model2, final Model<UpdateStatus> model3) {
        return new AbstractCommandStep(){

            protected boolean forwardVisitStep() {
                model2.set((Object)ProductSetStatus.SAME_LEVEL_NO_CHANGE);
                AvailableProduct[] availableProductArray = ((Installer)model.get()).getAvailableProducts();
                for (AvailableProduct object2 : availableProductArray) {
                    object2.setSelected(true);
                    object2.setOverwrite(true);
                }
                Collection collection = InstalledProductFactory.getInstalledProducts((String)((String)defaultedModel.get()));
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (AvailableProduct availableProduct : availableProductArray) {
                    arrayList2.add(availableProduct.getProductNumber());
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    InstalledProduct installedProduct = (InstalledProduct)iterator.next();
                    arrayList.add(installedProduct.getNumber());
                }
                block0 : switch (((UpdateStatus)model3.get()).getStatus()) {
                    case UP_GRADE: {
                        InstallAgentCommandStepFactoryImpl.this.setProductStatusModel(arrayList, arrayList2, list, (Model<ProductSetStatus>)model2);
                        break;
                    }
                    case DOWN_GRADE: {
                        InstallAgentCommandStepFactoryImpl.this.setProductStatusModel(arrayList, arrayList2, list, (Model<ProductSetStatus>)model2);
                        break;
                    }
                    default: {
                        if (arrayList.size() == 0) break;
                        for (Integer n : list) {
                            if (arrayList.contains(n)) continue;
                            model2.set((Object)ProductSetStatus.SAME_LEVEL_ADDITIONAL);
                            break block0;
                        }
                    }
                }
                return true;
            }
        };
    }

    private void setProductStatusModel(List<Integer> list, List<Integer> list2, List<Integer> list3, Model<ProductSetStatus> model) {
        block4: {
            block5: {
                block2: {
                    block3: {
                        if (list2.isEmpty()) break block2;
                        if (!list2.containsAll(list)) break block3;
                        model.set((Object)ProductSetStatus.OFFLINE_SUPER_SET);
                        if (!list.containsAll(list2)) break block4;
                        model.set((Object)ProductSetStatus.OFFLINE_SAME_SET);
                        break block4;
                    }
                    model.set((Object)ProductSetStatus.OFFLINE_SUB_SET);
                    for (Integer n : list2) {
                        if (list.contains(n)) continue;
                        model.set((Object)ProductSetStatus.OFFLINE_MIS_MATCH);
                    }
                    break block4;
                }
                if (!list3.containsAll(list)) break block5;
                model.set((Object)ProductSetStatus.ONLINE_SUPER_SET);
                if (!list.containsAll(list3)) break block4;
                model.set((Object)ProductSetStatus.ONLINE_SAME_SET);
                break block4;
            }
            model.set((Object)ProductSetStatus.ONLINE_SUB_SET);
            for (Integer n : list3) {
                if (list.contains(n)) continue;
                model.set((Object)ProductSetStatus.ONLINE_MIS_MATCH);
            }
        }
    }

    @Override
    public final Step createMCRProductSelectionAndGetConfirmationTextStep(Installer installer, DefaultedModel<String> defaultedModel, InstallWizardContext installWizardContext, Model<ProductSetStatus> model, List<Integer> list, String string, Model<File> model2, FileSystem fileSystem, Model<Boolean> model3, Model<String> model4, boolean bl, Model<UpdateStatus> model5, Model<Boolean> model6) {
        return new MCRProductSelectionAndGetConfirmationTextStep(installer, defaultedModel, installWizardContext, list, string, model2, fileSystem, model3, model4, bl, model5, model6);
    }

    @Override
    public Step createDownloadFolderStep(DefaultedModel<String> defaultedModel, Model<Path> model) {
        return new GenerateTempDownloadFolder(defaultedModel, model, this.logger);
    }

    @Override
    public Step createGetNeedToUpdateModelStep(final Model<UpdateStatus> model, final Model<ProductSetStatus> model2, final Model<Boolean> model3) {
        return new AbstractCommandStep(){

            protected boolean forwardVisitStep() {
                UpdateStatus updateStatus = (UpdateStatus)model.get();
                UpdateStatus.Status status = updateStatus.getStatus();
                ProductSetStatus productSetStatus = (ProductSetStatus)((Object)model2.get());
                switch (status) {
                    case UP_GRADE: {
                        model3.set((Object)true);
                        break;
                    }
                    case DOWN_GRADE: {
                        if (productSetStatus == ProductSetStatus.ONLINE_SUPER_SET || productSetStatus == ProductSetStatus.ONLINE_MIS_MATCH) {
                            model3.set((Object)true);
                            break;
                        }
                        model3.set((Object)false);
                        break;
                    }
                    case SAME_LEVEL: {
                        if (productSetStatus == ProductSetStatus.SAME_LEVEL_NO_CHANGE) {
                            model3.set((Object)false);
                            break;
                        }
                        model3.set((Object)true);
                        break;
                    }
                    case FRESH_INSTALL: {
                        model3.set((Object)false);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Step createDeleteDWSArchivesStep(final Model<Path> model) {
        return new AbstractCommandStep(){

            protected boolean forwardVisitStep() {
                try {
                    InstallAgentCommandStepFactoryImpl.this.io.deleteDirectory(((Path)model.get()).toFile());
                }
                catch (IOException iOException) {
                    InstallAgentCommandStepFactoryImpl.this.exceptionHandler.handleException((Throwable)iOException);
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckShouldShowErrorStep(final Model<UpdateStatus> model, final Model<ProductSetStatus> model2, final Model<Boolean> model3) {
        return new AbstractCommandStep(){

            protected boolean forwardVisitStep() {
                UpdateStatus updateStatus = (UpdateStatus)model.get();
                UpdateStatus.Status status = updateStatus.getStatus();
                ProductSetStatus productSetStatus = (ProductSetStatus)((Object)model2.get());
                switch (status) {
                    case UP_GRADE: {
                        if (productSetStatus.equals((Object)ProductSetStatus.OFFLINE_SUB_SET) || productSetStatus.equals((Object)ProductSetStatus.OFFLINE_MIS_MATCH)) {
                            model3.set((Object)true);
                            break;
                        }
                        model3.set((Object)false);
                        break;
                    }
                    case DOWN_GRADE: {
                        if (productSetStatus.equals((Object)ProductSetStatus.OFFLINE_SUPER_SET) || productSetStatus.equals((Object)ProductSetStatus.OFFLINE_MIS_MATCH)) {
                            model3.set((Object)true);
                            break;
                        }
                        model3.set((Object)false);
                        break;
                    }
                    default: {
                        model3.set((Object)false);
                    }
                }
                return true;
            }
        };
    }

    private boolean checkIfNoMCRProductsInstalled(DefaultedModel<String> defaultedModel) {
        List list = (List)InstalledProductFactory.getInstalledProducts((String)((String)defaultedModel.get()));
        boolean bl = true;
        for (InstalledProduct installedProduct : list) {
            int n = installedProduct.getNumber();
            if (n < 35000 || n > 36000) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

