/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.command;

import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installagent.command.AbstractMCRDWSCallable;
import com.mathworks.installagent.command.MCRDWSRestClientProxy;
import com.mathworks.installagent.updates.UpdateStatus;
import com.mathworks.installwizard.command.WebServiceStatus;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.mcrdws.v2.model.ComponentsRequest;
import com.mathworks.webservices.mcrdws.v2.model.ComponentsResponse;
import com.mathworks.webservices.mcrdws.v2.model.InputComponent;
import com.mathworks.webservices.mcrdws.v2.model.OutputComponent;
import com.mathworks.webservices.mcrdws.v2.model.ReleaseData;
import com.mathworks.webservices.mcrdws.v2.model.ReleaseDataResponse;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class GetRuntimeComponentsCallable
extends AbstractMCRDWSCallable<ComponentsResponse> {
    private final InstallerBuilder installerBuilder;
    private final Model<WebServiceStatus> webServiceStatusModel;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final MCRDWSRestClientProxy mcrdwsRestClientProxy;
    private final UpdateStatus updateStatus;
    private IO io;

    GetRuntimeComponentsCallable(ExceptionHandler exceptionHandler, String string, InstallerBuilder installerBuilder, Model<WebServiceStatus> model, Downloader downloader, ProxyConfiguration proxyConfiguration, IO iO, String string2, MCRDWSRestClientProxy mCRDWSRestClientProxy, Model<UpdateStatus> model2) {
        super(exceptionHandler, string2, string);
        this.io = iO;
        this.installerBuilder = installerBuilder;
        this.webServiceStatusModel = model;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.mcrdwsRestClientProxy = mCRDWSRestClientProxy;
        this.updateStatus = (UpdateStatus)model2.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ComponentsResponse doCall(String string, String string2, String string3, String string4) throws IOException, InterruptedException, MathWorksClientException, MathWorksServiceException {
        String string5 = this.updateStatus.getTargetReleaseStatus();
        String string6 = this.updateStatus.getTargetUpdateLevel();
        if (this.updateStatus.getStatus() == UpdateStatus.Status.DOWN_GRADE) {
            string5 = this.updateStatus.getCurrentReleaseStatus();
            string6 = this.updateStatus.getCurrentUpdateLevel();
        }
        String string7 = string6;
        MyComponentURLProvider myComponentURLProvider = new MyComponentURLProvider(string, string3, string4, string2, string5, string6, string7, this.mcrdwsRestClientProxy);
        WebServiceStatus webServiceStatus = (WebServiceStatus)this.webServiceStatusModel.get();
        if (webServiceStatus.isWebServiceUp()) {
            ReleaseDataResponse releaseDataResponse = webServiceStatus.getReleaseDataResponse();
            for (ReleaseData releaseData : releaseDataResponse.getReleaseData()) {
                File file = null;
                try {
                    file = File.createTempFile("dwsZipFile", null);
                    URL uRL = new URL(releaseData.getUrl());
                    this.downloader.download(this.proxyConfiguration, uRL, file, new IOObserver[0]);
                    this.installerBuilder.addReleaseData(file, (ComponentURLProvider)myComponentURLProvider);
                }
                finally {
                    this.io.deleteFile(file);
                }
            }
            return myComponentURLProvider.doCall();
        }
        return new ComponentsResponse();
    }

    @Override
    protected void apply(ComponentsResponse componentsResponse) {
    }

    private static class MyComponentURLProvider
    implements ComponentURLProvider {
        private String token;
        private final String clientString;
        private final String localeString;
        private final Collection<InputComponent> inputComponents = new ArrayList<InputComponent>();
        private final Map<String, String> componentToURLMap = new HashMap<String, String>();
        private final String releaseString;
        private final String status;
        private final String currentUpdateLevel;
        private final String targetUpdateLevel;
        private final MCRDWSRestClientProxy mcrdwsRestClientProxy;

        MyComponentURLProvider(String string, String string2, String string3, String string4, String string5, String string6, String string7, MCRDWSRestClientProxy mCRDWSRestClientProxy) {
            this.token = string;
            this.clientString = string3;
            this.localeString = string2;
            this.releaseString = string4;
            this.status = string5;
            this.currentUpdateLevel = string6;
            this.targetUpdateLevel = string7;
            this.mcrdwsRestClientProxy = mCRDWSRestClientProxy;
        }

        private ComponentsResponse doCall() throws MathWorksClientException, MathWorksServiceException {
            ComponentsRequest componentsRequest = new ComponentsRequest();
            componentsRequest.setRelease(this.releaseString);
            componentsRequest.setStatus(this.status);
            componentsRequest.setCurrentUpdateLevel(this.currentUpdateLevel);
            componentsRequest.setTargetUpdateLevel(this.targetUpdateLevel);
            InputComponent[] inputComponentArray = this.inputComponents.toArray(new InputComponent[0]);
            componentsRequest.setComponents(inputComponentArray);
            try {
                ComponentsResponse componentsResponse = this.mcrdwsRestClientProxy.getComponents(this.token, this.localeString, this.clientString, componentsRequest);
                for (OutputComponent outputComponent : componentsResponse.getComponents()) {
                    String string = outputComponent.getName();
                    this.componentToURLMap.put(string, outputComponent.getUrl());
                }
                return componentsResponse;
            }
            catch (Exception exception) {
                ComponentsResponse componentsResponse = new ComponentsResponse();
                return componentsResponse;
            }
        }

        public String getURL(String string, String string2) {
            return this.componentToURLMap.get(string);
        }

        public void add(String string, String string2) {
            InputComponent inputComponent = new InputComponent();
            inputComponent.setName(string);
            inputComponent.setVersion(string2);
            this.inputComponents.add(inputComponent);
        }
    }
}

