/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.command.Command;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

final class DeployUserAppCommand
implements Command {
    private final Model<File> userAppLocationModel;
    private final File bundleFile;
    private final ArchiveInputStreamExtractor extractor;
    private String manifestFileName;
    private List<String> filesUsedByInstallagent;

    DeployUserAppCommand(File file, Model<File> model, ArchiveInputStreamExtractor archiveInputStreamExtractor, String string, List<String> list) {
        this.bundleFile = file;
        this.userAppLocationModel = model;
        this.extractor = archiveInputStreamExtractor;
        this.manifestFileName = string;
        this.filesUsedByInstallagent = list;
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.extractor.extract((InputStream)FileUtils.openInputStream((File)this.bundleFile), (File)this.userAppLocationModel.get(), installFlowControlHandler, new InstallStatusObserver[0]);
        this.removeUnusedFiles((File)this.userAppLocationModel.get());
    }

    private void removeUnusedFiles(File file) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(new File(file, this.manifestFileName));
        for (String object : this.filesUsedByInstallagent) {
            arrayList.add(new File(file, object));
        }
        for (File file2 : arrayList) {
            if (!file2.exists()) continue;
            FileUtils.forceDelete((File)file2);
        }
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }
}

