/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installagent.InstallAgentResourceKeys;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.Callable;

abstract class AbstractMCRDWSCallable<R>
implements Callable<Boolean> {
    private static final String RELEASE_STRING = WizardResourceKeys.RELEASE.getString(new Object[0]);
    private static final String TOKEN = "MW-MCR-INSTALLER";
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String title;
    private final String message;

    AbstractMCRDWSCallable(ExceptionHandler exceptionHandler, String string, String string2) {
        this(exceptionHandler, string2, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), InstallAgentResourceKeys.ERROR_CONNECTION_MESSAGE.getString(RELEASE_STRING, string));
    }

    AbstractMCRDWSCallable(ExceptionHandler exceptionHandler, String string, String string2, String string3) {
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.title = string2;
        this.message = string3;
    }

    @Override
    public final Boolean call() throws InterruptedException {
        try {
            R r = this.doCall(TOKEN, RELEASE_STRING, Locale.getDefault().toString(), this.clientString);
            this.apply(r);
        }
        catch (MathWorksClientException | MathWorksServiceException | IOException throwable) {
            this.exceptionHandler.handleException(throwable, this.title, this.message);
            return false;
        }
        return true;
    }

    protected abstract R doCall(String var1, String var2, String var3, String var4) throws IOException, InterruptedException, MathWorksClientException, MathWorksServiceException;

    protected abstract void apply(R var1);
}

