/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.UserAppInstallationPropertiesImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

final class UserAppInstallationPropertiesLoader {
    protected static final String MANIFEST_FILE_NAME = "ApplicationInstallerManifest.xml";

    UserAppInstallationPropertiesLoader() {
    }

    static UserAppInstallationProperties loadUserAppInstallationProperties(File file) {
        boolean bl = false;
        String string = "Not_found";
        long l = 0L;
        try {
            string = UserAppInstallationPropertiesLoader.loadManifest(file);
            l = UserAppInstallationPropertiesLoader.calUserAppSize(file);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return new UserAppInstallationPropertiesImpl(string, l, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadManifest(File file) throws IllegalStateException, IOException {
        String string = "";
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry(MANIFEST_FILE_NAME);
        if (zipEntry != null) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                string = IOUtils.toString((InputStream)inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        } else {
            throw new IllegalStateException();
        }
        return string;
    }

    private static long calUserAppSize(File file) throws IOException {
        long l = 0L;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                l += zipEntry.getSize();
            }
        }
        return l /= 0x100000L;
    }
}

