/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.DefaultedModelImpl;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class UserAppInstallationPropertiesImpl
implements UserAppInstallationProperties {
    private static final String PROPERTY_NOT_SET = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private static final String WINDOWS_PROGRAM_FILES_ENV_VARIABLE = "%ProgramFiles%";
    private static final String WINDOWS_APPDATA_ENV_VARIABLE = "%AppData%";
    public static final String EMPTY_STRING = "";
    private String applicationName = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String defaultInstallationFolder = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private final long userAppUncompressedSize;
    private final File bundle;
    private final DefaultedModel<File> userAppInstallModel;
    private String executableName = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String guid = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String iconName = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String splashScreenImageName = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String logoImageName = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String version = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String addRemoveProgramIcon = "Installbundle parameter not stasdvmaasvndlkasgasd90ubgb";
    private String installNotesText = "";
    private String authorOrganization = "";
    private String summaryText = "";
    private String welcomePanelText = "";
    private boolean validBundle;
    private ImageIcon userLogo;
    private List<Image> userIcons;
    private List<String> filesUsedByInstallAgent;
    private List<Integer> mcrExternalProductIdentifiers;
    private static final String APPLICATION_NAME_ELEMENT_NAME = "ApplicationName";
    private static final String DEFAULT_INSTALLATION_DIRECTORY_ELEMENT_NAME = "DefaultInstallationDirectory";
    private static final String EXECUTABLE_NAME_ELEMENT_NAME = "ExecutableName";
    private static final String GUID_ELEMENT_NAME = "GUID";
    private static final String ICON_ELEMENT_NAME = "ApplicationIcon";
    private static final String SPLASH_SCREEN_ELEMENT_NAME = "SplashScreen";
    private static final String LOGO_ELEMENT_NAME = "Logo";
    private static final String VERSION_ELEMENT_NAME = "Version";
    private static final String INSTALLATION_NOTES_ELEMENT_NAME = "InstallationNotes";
    private static final String AUTHOR_ORGANIZATION_ELEMENT_NAME = "AuthorOrganization";
    private static final String SUMMARY_ELEMENT_NAME = "Summary";
    private static final String WELCOME_PANEL_TEXT_ELEMENT_NAME = "WelcomePanelText";
    private static final String PROGRAM_ICON_ELEMENT_NAME = "AddRemoveProgramIcon";
    private static final String DLL_EXTENSION = ".dll";
    private static final String MCR_PRODUCTS_ELEMENT_NAME = "MCRProducts";
    private static final String MCR_PRODUCT_ELEMENT_NAME = "MCRProduct";
    private static final String MCR_PRODUCT_IDENTIFIER_ELEMENT_NAME = "ExternalProductIdentifier";

    UserAppInstallationPropertiesImpl(String string, long l, File file, boolean bl) {
        this.userAppUncompressedSize = l;
        this.bundle = file;
        this.mcrExternalProductIdentifiers = new ArrayList<Integer>();
        if (bl) {
            try {
                this.loadProperties(string);
                this.userLogo = this.loadUserLogo();
                this.userIcons = this.loadUserIcons();
                this.validBundle = true;
            }
            catch (Exception exception) {
                this.validBundle = false;
            }
        } else {
            this.userLogo = new ImageIcon();
            this.userIcons = new ArrayList<Image>();
        }
        File file2 = new File(this.getDefaultInstallationLocation());
        this.userAppInstallModel = new DefaultedModelImpl((Object)file2);
        this.loadFilesUsedByInstallAgent();
    }

    @Override
    public DefaultedModel<File> getUserAppInstallLocationModel() {
        return this.userAppInstallModel;
    }

    @Override
    public ImageIcon getUserLogo() {
        return this.userLogo;
    }

    @Override
    public List<Image> getUserIcons() {
        return this.userIcons;
    }

    @Override
    public boolean validBundle() {
        return this.validBundle;
    }

    @Override
    public String getDefaultInstallationLocation() {
        return this.defaultInstallationFolder;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public long getUserAppUncompressedSize() {
        return this.userAppUncompressedSize;
    }

    @Override
    public String getExecutableName() {
        return this.executableName;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getSplashScreenImageName() {
        return this.splashScreenImageName;
    }

    @Override
    public String getLogoImageName() {
        return this.logoImageName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAddRemoveProgramIcon() {
        return this.addRemoveProgramIcon;
    }

    @Override
    public String getInstallNotesText() {
        return this.installNotesText;
    }

    @Override
    public String getAuthorOrganizationText() {
        return this.authorOrganization;
    }

    @Override
    public String getSummaryText() {
        return this.summaryText;
    }

    @Override
    public String getWelcomePanelText() {
        return this.welcomePanelText;
    }

    @Override
    public File getBundle() {
        return this.bundle;
    }

    @Override
    public String getRegisterDllPath() {
        return this.executableName.endsWith(DLL_EXTENSION) ? this.executableName : EMPTY_STRING;
    }

    @Override
    public String getShortCutPath() {
        if (this.executableName != null && !this.executableName.endsWith(".exe")) {
            return this.executableName.substring(0, this.executableName.lastIndexOf(File.separator));
        }
        return this.executableName;
    }

    @Override
    public List<String> getFilesUsedbyInstallAgent() {
        return this.filesUsedByInstallAgent;
    }

    @Override
    public List<Integer> getRequiredMCRProductIdentifiers() {
        return this.mcrExternalProductIdentifiers;
    }

    private void setDefaultInstallationFolder(String string) {
        this.defaultInstallationFolder = string.startsWith(WINDOWS_PROGRAM_FILES_ENV_VARIABLE) ? System.getenv("ProgramFiles") + string.substring(WINDOWS_PROGRAM_FILES_ENV_VARIABLE.length()) : (string.startsWith(WINDOWS_APPDATA_ENV_VARIABLE) ? System.getenv("AppData") + string.substring(WINDOWS_APPDATA_ENV_VARIABLE.length()) : string);
    }

    private ImageIcon loadUserLogo() throws IOException {
        this.userLogo = new ImageIcon();
        this.userLogo.setImage(this.getImageFromBundle(this.getLogoImageName()));
        return this.userLogo;
    }

    private List<Image> loadUserIcons() throws IOException {
        this.userIcons = new ArrayList<Image>();
        this.userIcons.add(this.getImageFromBundle(this.getIconName()));
        return this.userIcons;
    }

    private List<String> loadFilesUsedByInstallAgent() {
        this.filesUsedByInstallAgent = new ArrayList<String>();
        this.filesUsedByInstallAgent.add(this.iconName);
        this.filesUsedByInstallAgent.add(this.splashScreenImageName);
        this.filesUsedByInstallAgent.add(this.logoImageName);
        return this.filesUsedByInstallAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImageFromBundle(String string) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
        ZipFile zipFile = new ZipFile(this.bundle);
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                bufferedImage = ImageIO.read(inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return bufferedImage;
    }

    private void loadProperties(String string) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
        NodeList nodeList = document.getElementsByTagName("ApplicationInstallerManifest");
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        block32: for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            switch (node2.getNodeName()) {
                case "DefaultInstallationDirectory": {
                    this.setDefaultInstallationFolder(node2.getTextContent());
                    continue block32;
                }
                case "ApplicationName": {
                    this.applicationName = node2.getTextContent();
                    continue block32;
                }
                case "ExecutableName": {
                    this.executableName = node2.getTextContent();
                    continue block32;
                }
                case "GUID": {
                    this.guid = node2.getTextContent();
                    continue block32;
                }
                case "ApplicationIcon": {
                    this.iconName = node2.getTextContent();
                    continue block32;
                }
                case "SplashScreen": {
                    this.splashScreenImageName = node2.getTextContent();
                    continue block32;
                }
                case "Logo": {
                    this.logoImageName = node2.getTextContent();
                    continue block32;
                }
                case "Version": {
                    this.version = node2.getTextContent();
                    continue block32;
                }
                case "AddRemoveProgramIcon": {
                    this.addRemoveProgramIcon = node2.getTextContent();
                    continue block32;
                }
                case "InstallationNotes": {
                    this.installNotesText = node2.getTextContent();
                    continue block32;
                }
                case "AuthorOrganization": {
                    this.authorOrganization = node2.getTextContent();
                    continue block32;
                }
                case "Summary": {
                    this.summaryText = node2.getTextContent();
                    continue block32;
                }
                case "WelcomePanelText": {
                    this.welcomePanelText = node2.getTextContent();
                    continue block32;
                }
                case "MCRProducts": {
                    this.retrieveRequiredMCRProductIdentifiers(node2);
                }
            }
        }
    }

    private void retrieveRequiredMCRProductIdentifiers(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(MCR_PRODUCT_ELEMENT_NAME)) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equals(MCR_PRODUCT_IDENTIFIER_ELEMENT_NAME)) continue;
                this.mcrExternalProductIdentifiers.add(Integer.parseInt(node3.getTextContent()));
            }
        }
    }
}

