/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.mathworks.install.ProductCorrelator;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installagent.ValidatedFikInstallAgent;
import com.mathworks.installagent.updates.MCRProductCorrelatorImpl;
import com.mathworks.installagent.workflow.mcrworkflow.MCRInstallWorkflowFactory;
import com.mathworks.installagent.workflow.mcrworkflow.MCRInstallWorkflowFactoryImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import java.io.File;

public class MCRInstallerModule
extends AbstractModule {
    private final ResourceRetriever resourceRetriever;

    public MCRInstallerModule(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    protected void configure() {
        this.bind(MCRInstallWorkflowFactory.class).to(MCRInstallWorkflowFactoryImpl.class);
        this.bind(ValidatedFik.class).to(ValidatedFikInstallAgent.class);
        this.bind(ResourceRetriever.class).toInstance((Object)this.resourceRetriever);
        this.bind(Platform.class).toInstance((Object)new PlatformImpl());
    }

    @Provides
    static Workflow provideWorkflow(MCRInstallWorkflowFactory mCRInstallWorkflowFactory, File file) {
        return mCRInstallWorkflowFactory.createInitialWorkflow(file);
    }

    @Provides
    @Singleton
    ProductCorrelator provideProductCorrelator(SourcePathProvider sourcePathProvider, AppLogger appLogger) {
        return new MCRProductCorrelatorImpl(sourcePathProvider, appLogger);
    }
}

