/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.mathworks.install.BooleanHolder;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.LoggingCommandErrorHandler;
import com.mathworks.install.Product;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.condition.Condition;
import com.mathworks.install.exception.InstallerRequirementNotSatisfiedException;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install_core_common.AbstractMathworksInstallConfiguration;
import com.mathworks.install_impl.InstallOptionImpl;
import com.mathworks.install_impl.InstalledProductFactory;
import com.mathworks.installagent.InstallAgentResourceKeys;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class MCRInstallConfiguration
extends AbstractMathworksInstallConfiguration {
    private static final String MCR_USAGE_ID = "mcr";
    private static final Command[] NO_COMMANDS = new Command[0];
    private static final Product[] NO_PRODUCTS = new Product[0];
    private final BooleanHolder isPathTooLong = new BooleanHolder(false);

    public final String getDefaultDirectoryName(Platform platform, Product[] productArray) {
        return MCRInstallConfiguration.getApplicationName();
    }

    public Command[] createStartMenuShortcutCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        return NO_COMMANDS;
    }

    public Command[] createDesktopShortcutCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return NO_COMMANDS;
    }

    public Command[] createDesktopShortcutForPolyspaceCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return NO_COMMANDS;
    }

    public Command[] createStartMenuShortcutForPolyspaceCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        return NO_COMMANDS;
    }

    public final void activateInstallation(Properties properties) {
    }

    public final String[] getSetupNotes(File file, InstallOption[] installOptionArray, HyperlinkProvider hyperlinkProvider, String string, Installer installer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isPathTooLong.get()) {
            arrayList.add(InstallAgentResourceKeys.MCR_PATH1.getString(file.getAbsolutePath()));
            arrayList.add(InstallAgentResourceKeys.MCR_PATH2.getString(new Object[0]));
        }
        arrayList.add(InstallAgentResourceKeys.MCR_NOTE1.getString(new Object[0]));
        arrayList.add(InstallAgentResourceKeys.MCR_NOTE1_COMMAND.getString(file.getAbsolutePath()));
        arrayList.add(InstallAgentResourceKeys.MCR_NOTE1_MPS.getString(new Object[0]));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final String getInstallationPath(String string) {
        File file = new File(string);
        String string2 = InstallAgentResourceKeys.MCR_VERSION.getString(new Object[0]);
        if (FilenameUtils.equalsOnSystem((String)file.getName(), (String)string2)) {
            return string;
        }
        return new File(string, string2).getPath();
    }

    public final Command[] getPreInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory) {
        return NO_COMMANDS;
    }

    public Command[] getAdditionalPostInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory, IO iO, Properties properties) {
        String string2 = properties.getProperty("root");
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string3 = MCRInstallConfiguration.buildPath("bin", string);
        String string4 = MCRInstallConfiguration.buildPath("runtime", string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string4);
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "java", "config", "installagent").toString(), Paths.get("uninstall", "java", "config", "installagent").toString(), (FilenameFilter)FileFilterUtils.nameFileFilter((String)"pathlist.jar")));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(Paths.get(string2, "java", "config", "default").toString(), Paths.get("java", "config", "default").toString(), (FilenameFilter)FileFilterUtils.suffixFileFilter((String)"config")));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createInsertPathIntoSystemPathCommand(string4, "", this.isPathTooLong));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_NET_Product})) {
            ArrayList<Command> arrayList3 = new ArrayList<Command>();
            String string5 = MCRInstallConfiguration.buildPath("toolbox", "dotnetbuilder", "bin", string, "v4.0");
            arrayList3.add(commandFactory.createInstallAssemblyFilesCommand(string5, new String[]{"MWArray.dll"}));
            arrayList3.add(commandFactory.createRegisterAssemblyFolderCommand("DotNetBuilder", string5));
            arrayList.add(commandFactory.createAssemblyFrameworkCommand(InstallAgentResourceKeys.DOT_NET_BUILDER_MCR_WARNING.getString(new Object[0]), (CommandErrorHandler)new LoggingCommandErrorHandler(), arrayList3.toArray(new Command[arrayList3.size()])));
            arrayList.add(commandFactory.createRegisterDllsWithPathsCommand(string3, arrayList2, new String[]{"mwcomutil.dll", "mwcommgr.dll"}));
        }
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public final boolean isSupported(String string) {
        return MCR_USAGE_ID.equalsIgnoreCase(string);
    }

    public final String getDefaultInstallationDirectory(Platform platform, Product[] productArray) {
        if (platform.isWindows()) {
            return "MATLAB".concat(File.separator).concat(this.getDefaultDirectoryName(platform, productArray));
        }
        return "MATLAB".concat(File.separator).concat(this.getDefaultDirectoryName(platform, productArray).replaceAll(" ", "_"));
    }

    public final Command[] getAdditionalPostUninstallCommands(String string, Product[] productArray, CommandFactory commandFactory, IO iO) {
        return NO_COMMANDS;
    }

    public void deactivateInstallation(String string, Product[] productArray, String[] stringArray) {
    }

    public final String getUsageId(String string, Product[] productArray) {
        return MCR_USAGE_ID;
    }

    public final String getUsageString(String string, Product[] productArray) {
        return MCRInstallConfiguration.getApplicationName();
    }

    public void activateInstallation(String[] stringArray) {
    }

    public final boolean canActivate(String string) {
        return false;
    }

    public final String[] getAdditionalBaseNames() {
        return new String[]{"com.mathworks.installagent.resources.RES_InstallAgent"};
    }

    public final InstallOption[] getUninstallOptions(String string, Product[] productArray, InstallOption ... installOptionArray) {
        ArrayList<InstallOptionImpl> arrayList = new ArrayList<InstallOptionImpl>();
        InstallOptionImpl installOptionImpl = new InstallOptionImpl(InstallOptionType.NOT_SHOW_PRODUCT_TABLE.toString(), true, InstallOptionType.NOT_SHOW_PRODUCT_TABLE);
        arrayList.add(installOptionImpl);
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    public final boolean canChooseTypicalOrCustom() {
        return false;
    }

    public final boolean canChangeFolder(Platform platform, Registry registry, Installer installer) {
        return this.shouldAllowFolderChangeIfAlreadyInstalled(platform) || !this.isApplicationLocationStoredInRegistry(registry, platform.getArchString(), NO_PRODUCTS) || !MCRInstallConfiguration.mcrAlreadyInstalled(new File(this.getInstallationPath(this.getApplicationLocation(registry, platform.getArchString(), NO_PRODUCTS))), installer);
    }

    private static boolean mcrAlreadyInstalled(File file, Installer installer) {
        boolean bl = installer.getAvailableProducts().length == 0 ? !InstalledProductFactory.getInstalledProducts((String)file.getAbsolutePath()).isEmpty() : installer.getSelectedProductsAlreadyInstalled(file).length > 0;
        return bl;
    }

    private static String getApplicationName() {
        return InstallAgentResourceKeys.PRODUCT_NAME.getString(new Object[0]);
    }

    protected String getApplicationName(String string, Collection<? extends Product> collection) {
        return MCRInstallConfiguration.getApplicationName();
    }

    protected void addAdditionalRegisterApplicationCommands(String string, CommandFactory commandFactory, Collection<Command> collection, Collection<Product> collection2) {
    }

    protected final String getPathToRegister(String string) {
        String string2 = File.separator + InstallAgentResourceKeys.MCR_VERSION.getString(new Object[0]);
        if (string.endsWith(string2)) {
            return string.substring(0, string.indexOf(string2));
        }
        return string;
    }

    protected final void checkAdditionalInstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
    }

    protected final void checkAdditionalUninstallerRequirements(InstallerRequirements installerRequirements) throws InstallerRequirementNotSatisfiedException {
    }

    protected final String getApplicationVersion(String string, Collection<? extends Product> collection) {
        return InstallAgentResourceKeys.RELEASE_NUM.getString(new Object[0]);
    }

    public final String getUninstallProgramsEntryName(String string, Collection<Product> collection) {
        return MCRInstallConfiguration.getApplicationName();
    }

    public final String getUninstallProgramsEntryVersion(String string, Collection<? extends Product> collection) {
        return InstallAgentResourceKeys.RELEASE_NUM.getString(new Object[0]);
    }

    public final String getUninstallProgramsEntryDisplayName(String string, Collection<Product> collection) {
        return InstallResourceKeys.ITEM_WITH_ARCH_QUALIFICATION.getString(new Object[]{MCRInstallConfiguration.getApplicationName(), InstallAgentResourceKeys.RELEASE_NUM.getString(new Object[0])});
    }

    protected static String buildPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(File.separator);
        }
        return stringBuilder.toString();
    }

    public final boolean shouldAllowFolderChangeIfAlreadyInstalled(Platform platform) {
        return !platform.isWindows();
    }

    public final Command[] createSymbolicLinkCommands(Product[] productArray, String string, InstallOption installOption, CommandFactory commandFactory) {
        return NO_COMMANDS;
    }

    public final boolean alwaysUseDefaultInstallFolderModel(String string, Product[] productArray) {
        return true;
    }

    public String getHyperlinkClientIdentifier() {
        return "mr";
    }

    protected final String getLicenseAgreementPath() {
        return InstallAgentResourceKeys.MCR_LICENSE_AGREEMENT.getString(new Object[0]);
    }

    public boolean requiresLicenseAgreement() {
        return true;
    }
}

