/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.mathworks.instutil.Arch;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.ResourceRetrieverImpl;
import java.util.EnumMap;
import java.util.Map;

public enum InstallAgentResourceKeys {
    BUNDLE_ERROR("bundle.error"),
    ERROR_CONNECTION_MESSAGE("error.connection"),
    BUNDLE_ERROR_TITLE("bundle.error.title"),
    PRODUCT_NAME("product.name"),
    RELEASE_NUM("release.num"),
    MCR_VERSION("mcr.version"),
    DOT_NET_BUILDER_MCR_WARNING("mcr.netbuilder.warning"),
    MCR_LICENSE_AGREEMENT("mcr.license.agreement"),
    MCR_PATH1("win64.path1.txt"),
    MCR_PATH2("win64.path2.txt"),
    MCR_NOTE1("win.readme1.txt", "win.readme1.txt", "maci64.readme1.txt", "glnxa64.readme1.txt"),
    MCR_NOTE1_COMMAND("win.readme1.cmd", "win.readme1.cmd", "maci64.readme1.cmd", "glnxa64.readme1.cmd"),
    MCR_NOTE1_MPS("win.readme2.txt", "win.readme2.txt", "glnxa64.maci64.readme2.txt", "glnxa64.maci64.readme2.txt");

    private static final PlatformImpl PLATFORM;
    private static final String[] BASENAMES;
    private static final ResourceRetriever RETRIEVER;
    private Map<Arch, String> resourceKeyMap = new EnumMap<Arch, String>(Arch.class);

    private InstallAgentResourceKeys(String string2) {
        this(string2, string2, string2);
        for (Arch arch : Arch.values()) {
            this.resourceKeyMap.put(arch, string2);
        }
    }

    private InstallAgentResourceKeys(String string2, String string3, String string4) {
        this(string2, string2, string3, string4);
    }

    private InstallAgentResourceKeys(String string2, String string3, String string4, String string5) {
        this.resourceKeyMap.put(Arch.WIN32, string2);
        this.resourceKeyMap.put(Arch.WIN64, string3);
        this.resourceKeyMap.put(Arch.MACI64, string4);
        this.resourceKeyMap.put(Arch.GLNXA64, string5);
    }

    public String getString(Object ... objectArray) {
        return RETRIEVER.getResource(this.getResourceKeyForArch(PLATFORM.getArch()), objectArray);
    }

    String getResourceKeyForArch(Arch arch) {
        return this.resourceKeyMap.get(arch);
    }

    static {
        PLATFORM = new PlatformImpl();
        BASENAMES = new String[]{"com.mathworks.installagent.resources.RES_InstallAgent"};
        RETRIEVER = new ResourceRetrieverImpl(BASENAMES);
    }
}

