/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install_impl.InstallModule;
import com.mathworks.installagent.InstallAgentInstallConfiguration;
import com.mathworks.installagent.InstallAgentInstallerModule;
import com.mathworks.installagent.MCRInstallConfiguration;
import com.mathworks.installagent.MCRInstallerModule;
import com.mathworks.installwizard.InstallWizardModule;
import com.mathworks.installwizard.InstallerModule;
import com.mathworks.installwizard.model.ModelModule;
import com.mathworks.wizard.AbstractLauncher;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.ResourceRetrieverImpl;
import com.mathworks.wizard.model.ConnectionMode;
import java.util.Arrays;
import java.util.Collection;

public final class InstallAgentLauncher
extends AbstractLauncher {
    private static final String INSTALLBUNDLE = "-installbundle";
    private static int exitStatus = ExitStatus.FAILED.getExitCode();
    private static final ResourceRetriever resourceRetriever = new ResourceRetrieverImpl(new String[]{"com.mathworks.installagent.resources.RES_InstallAgent"});

    public static void main(String[] stringArray) {
        InstallAgentLauncher installAgentLauncher = new InstallAgentLauncher();
        if (Arrays.asList(stringArray).contains(INSTALLBUNDLE)) {
            installAgentLauncher.launchStandalone(stringArray, new Module[0]);
        } else {
            installAgentLauncher.launchStandalone(stringArray, InstallAgentLauncher.getOverrideModules());
        }
        exitStatus = installAgentLauncher.waitForExitCode();
    }

    public void launch(Collection<String> collection, Module ... moduleArray) {
        Module module = collection.contains(INSTALLBUNDLE) ? Modules.combine((Module[])moduleArray) : Modules.override((Module[])InstallAgentLauncher.getOverrideModules()).with(moduleArray);
        super.launch(collection, new Module[]{module});
    }

    public static int getExitStatus() {
        return exitStatus;
    }

    protected void addAdditionalArguments(Collection<String> collection) {
        collection.add('-' + PropertyKey.CONNECTION_MODE.get());
        collection.add(ConnectionMode.OFFLINE_ONLY.toString());
    }

    protected Module[] getModules() {
        InstallAgentInstallerModule installAgentInstallerModule = new InstallAgentInstallerModule(resourceRetriever);
        return new Module[]{Modules.override((Module[])new Module[]{new InstallerModule(), new InstallWizardModule(), new InstallModule((InstallConfiguration)new InstallAgentInstallConfiguration()), new ModelModule()}).with(new Module[]{installAgentInstallerModule})};
    }

    private static Module[] getOverrideModules() {
        MCRInstallerModule mCRInstallerModule = new MCRInstallerModule(resourceRetriever);
        return new Module[]{Modules.override((Module[])new Module[]{new InstallerModule(), new InstallWizardModule(), new InstallModule((InstallConfiguration)new MCRInstallConfiguration()), new ModelModule()}).with(new Module[]{mCRInstallerModule})};
    }
}

