/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.ProductCorrelator;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.command.Command;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installagent.InstallAgentResourceRetrieverImpl;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.UserAppInstallationPropertiesLoader;
import com.mathworks.installagent.ValidatedFikInstallAgent;
import com.mathworks.installagent.command.InstallAgentCommandStepFactory;
import com.mathworks.installagent.command.InstallAgentCommandStepFactoryBat;
import com.mathworks.installagent.command.InstallAgentCommandStepFactoryImpl;
import com.mathworks.installagent.command.MCRDWSRestClientProxy;
import com.mathworks.installagent.command.UserAppInstallationCommandFactory;
import com.mathworks.installagent.command.UserAppInstallationCommandFactoryImpl;
import com.mathworks.installagent.updates.MCRProductCorrelatorImpl;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactory;
import com.mathworks.installagent.workflow.InstallAgentWorkflowFactoryImpl;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.system.HostIdProvider;
import com.mathworks.instutil.system.HostIdProviderImpl;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.ImageResourceRetriever;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

final class InstallAgentInstallerModule
extends AbstractModule {
    private final ResourceRetriever resourceRetriever;
    static final String POST_INSTALL_COMMANDS = "PostInstallCommands";

    InstallAgentInstallerModule(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    protected void configure() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"clientString")).toInstance((Object)ResourceKeys.INSTALLAGENT_CLIENT_STRING.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0])}));
        this.bind(ValidatedFik.class).to(ValidatedFikInstallAgent.class);
        this.bind(Platform.class).toInstance((Object)new PlatformImpl());
        this.bind(UserAppInstallationCommandFactory.class).toInstance((Object)new UserAppInstallationCommandFactoryImpl());
        this.bind(MCRDWSRestClientProxy.class).toInstance((Object)new MCRDWSRestClientProxy());
    }

    @Provides
    @Singleton
    ResourceRetriever provideResourceRetriever(UserAppInstallationProperties userAppInstallationProperties) {
        return new InstallAgentResourceRetrieverImpl(this.resourceRetriever, userAppInstallationProperties);
    }

    @Provides
    InstallAgentWorkflowFactory provideWorkflowFactory(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallAgentCommandStepFactory installAgentCommandStepFactory, Properties properties, Registry registry, ValidatedFik validatedFik, UserAppInstallationProperties userAppInstallationProperties) {
        return new InstallAgentWorkflowFactoryImpl(installModelFactory, installCommandStepFactory, installAgentCommandStepFactory, properties, registry, validatedFik, userAppInstallationProperties, this.resourceRetriever.getImage(ImageResourceRetriever.MAIN_IMAGE, new Object[0]));
    }

    @Provides
    Workflow provideWorkflow(InstallAgentWorkflowFactory installAgentWorkflowFactory, SourcePathProvider sourcePathProvider, Properties properties, File file, UserAppInstallationProperties userAppInstallationProperties) {
        String string = sourcePathProvider.getSourcePath();
        ModelImpl modelImpl = new ModelImpl((Object)userAppInstallationProperties.validBundle());
        return installAgentWorkflowFactory.createInitialWorkflow((Model<Boolean>)modelImpl, string, file);
    }

    @Provides
    static InstallAgentCommandStepFactory provideInstallAgentCommandStepFactory(@Named(value="archString") String string, @Named(value="clientString") String string2, WizardUI wizardUI, InstallerBuilder installerBuilder, ExceptionHandler exceptionHandler, AppLogger appLogger, IO iO, WorkerFactory workerFactory, Downloader downloader, ProxyConfiguration proxyConfiguration, MCRDWSRestClientProxy mCRDWSRestClientProxy, Properties properties) {
        InstallAgentCommandStepFactoryImpl installAgentCommandStepFactoryImpl = new InstallAgentCommandStepFactoryImpl(string, wizardUI, installerBuilder, exceptionHandler, appLogger, string2, iO, workerFactory, downloader, proxyConfiguration, mCRDWSRestClientProxy);
        if (Boolean.valueOf(properties.getProperty("bat", "false")).booleanValue()) {
            return new InstallAgentCommandStepFactoryBat(installAgentCommandStepFactoryImpl);
        }
        return installAgentCommandStepFactoryImpl;
    }

    @Provides
    @Singleton
    ProductCorrelator provideProductCorrelator(SourcePathProvider sourcePathProvider, AppLogger appLogger) {
        return new MCRProductCorrelatorImpl(sourcePathProvider, appLogger);
    }

    @Provides
    static HostIdProvider provideIpConfig(SourcePathProvider sourcePathProvider, Platform platform) throws JNIException {
        return new HostIdProviderImpl(platform.getNativeLibraryPath(sourcePathProvider.getSourcePath()));
    }

    @Provides
    @Singleton
    UserAppInstallationProperties getUserAppInstallationProperties(Properties properties) {
        String string = properties.getProperty(PropertyKey.INSTALL_BUNDLE.get());
        File file = new File(string);
        return UserAppInstallationPropertiesLoader.loadUserAppInstallationProperties(file);
    }

    @Provides
    @Named(value="PostInstallCommands")
    List<Command> providePostInstallCommands(UserAppInstallationCommandFactory userAppInstallationCommandFactory, @Named(value="NoDecodeStream") ArchiveInputStreamExtractor archiveInputStreamExtractor, UserAppInstallationProperties userAppInstallationProperties) throws Exception {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (userAppInstallationProperties.validBundle()) {
            arrayList.add(userAppInstallationCommandFactory.createDeployUserApplicationCommand(userAppInstallationProperties.getBundle(), (Model<File>)userAppInstallationProperties.getUserAppInstallLocationModel(), archiveInputStreamExtractor, "ApplicationInstallerManifest.xml", userAppInstallationProperties.getFilesUsedbyInstallAgent()));
        }
        return arrayList;
    }
}

